package ru.yandex.autotests.direct.utils.strategy.data;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

public enum StrategyType implements ITextResource {

    HIGHEST_POSITION(StrategyName.HIGHEST_POSITION, "default", ""),
    MANUAL_CONTROL(StrategyName.MAXIMUM_CLICKS, "maximum_clicks", ""),
    CPM_MANUAL_CONTROL(StrategyName.DEFAULT, "cpm_default", ""),
    WEEKLY_BUDGET_MAX_CLICKS(StrategyName.WEEKLY_BUDGET, "autobudget", "clicks"),
    WEEKLY_BUDGET_MAX_CONVERSION(StrategyName.CPA_OPTIMIZER, "autobudget", "cpa"),
    BLOCK_MIN_PRICE(StrategyName.LOWEST_COST_PREMIUM, "min_price", "premium"),
    BLOCK_MIN_PRICE_GUARANTEE(StrategyName.LOWEST_COST, "min_price", "both"),
    AVERAGE_PRICE(StrategyName.AVERAGE_CLICK_PRICE, "autobudget_avg_click", ""),
    WEEKLY_PACKET_OF_CLICKS(StrategyName.WEEKLY_PACKET_OF_CLICKS, "autobudget_week_bundle", ""),
    INDEPENDENT_CONTROL(StrategyName.INDEPENDENT_CONTROL, "different_places", ""),
    MAX_COVERADGE(StrategyName.MAXIMUM_COVERAGE, "maximum_coverage", ""),
    DEFAULT(StrategyName.DEFAULT, "", ""),
    SHOWS_DISABLED(StrategyName.SHOWS_DISABLED, "stop", ""),
    AVERAGE_CPA_OPTIMIZATION(StrategyName.AVERAGE_CPA_OPTIMIZATION, "autobudget_avg_cpa", ""),
    ROI_OPTIMIZATION(StrategyName.ROI_OPTIMIZATION, "autobudget_roi", ""),
    AVERAGE_CPI_OPTIMIZATION(StrategyName.AUTOBUDGET_AVG_CPI, "autobudget_avg_cpi", ""),
    CPA_FILTER_OPTIMIZATION(StrategyName.AUTOBUDGET_CPA_OPTIMIZATION, "autobudget_optimization_cpa", "filter"),
    CPA_CAMPAIGN_OPTIMIZATION(StrategyName.AUTOBUDGET_CPA_OPTIMIZATION, "autobudget_optimization_cpa", "camp"),
    CPC_FILTER_OPTIMIZATION(StrategyName.CPC_OPTIMIZATION, "autobudget_optimization_cpc", "filter"),
    CPC_CAMPAIGN_OPTIMIZATION(StrategyName.CPC_OPTIMIZATION, "autobudget_optimization_cpc", "camp"),
    UNKNOWN("UNKNOWN", "", "");

    StrategyType(String apiKey, String uiPrimaryKey, String uiSecondaryKey) {
        this.uiPrimaryKey = uiPrimaryKey;
        this.uiSecondaryKey = uiSecondaryKey;
        this.apiKey = apiKey;
    }

    private String apiKey;
    private String uiPrimaryKey;
    private String uiSecondaryKey;

    private static String getResourceBundle() {
        return "web.campaigns.strategy.StrategyType";
    }

    public String getApiKey() {
        return apiKey;
    }

    public String getSubRadioKey() {
        if ("".equals(uiSecondaryKey)) {
            return null;
        }
        return uiSecondaryKey;
    }

    public String getRadioKey() {
        if (uiPrimaryKey == null) {
            return "";
        }
        return uiPrimaryKey;
    }

    public static StrategyType getStrategyTypeByRadioKey(String uiKey) {
        for (StrategyType strategyType : StrategyType.values()) {
            String key = strategyType.getRadioKey();
            if (strategyType.getSubRadioKey() != null) {
                key += ":" + strategyType.uiSecondaryKey;
            }
            if (key.replaceAll("(-|_)", "").equals(uiKey.replaceAll("(-|_)", ""))) {
                return strategyType;
            }
        }
        return null;
    }

    public static StrategyType getStrategyTypeByApiKey(String apiKey) {
        for (StrategyType strategyType : StrategyType.values()) {
            if (strategyType.apiKey.equals(apiKey)) {
                return strategyType;
            }
        }
        return null;
    }

    private static String BUNDLE = "web.campaigns.strategy.StrategyType";

    @Override
    public String getBundle() {
        return BUNDLE;
    }
}