package ru.yandex.autotests.direct.utils.strategy.objects;

import ru.yandex.autotests.direct.utils.strategy.data.StrategyType;

public class CampaignStrategyInfoWeb {

    private Boolean isIndependentControlStrategy;
    private StrategyType strategyType;

    private Double averageCPI;

    private Double cpcPerCamp;
    private Double cpcPerFilter;
    private Double maxClickBid;
    private Double weekBid;

    private Double cpaPerCamp;
    private Double cpaPerFilter;

    private Double maxPrice;
    private Double averagePrice;
    private Double weeklySumLimit;
    private Integer clicksPerWeek;
    private String strategyName;
    private Double averageCPA;
    private Integer goalID;
    private Integer reserveReturn;
    private Double ROICoef;
    private Double profitability;

    private String contextLimit;
    private Integer contextLimitSum;
    private Integer contextPricePercent;

    public Boolean getIsIndependentControlStrategy() {
        return isIndependentControlStrategy;
    }

    public void setIsIndependentControlStrategy(Boolean isIndependentControlStrategy) {
        this.isIndependentControlStrategy = isIndependentControlStrategy;
    }

    public StrategyType getStrategyType() {
        return strategyType;
    }

    public void setStrategyType(StrategyType type) {
        strategyType = type;
        setStrategyName(type.getApiKey());
    }

    public void setWeeklySumLimit(String sum) {
        this.weeklySumLimit = Double.parseDouble(sum);
    }

    public void setAveragePrice(String sum) {
        setAveragePrice(Double.parseDouble(sum));
    }

    public void setMaxPrice(String sum) {
        setMaxPrice(Double.parseDouble(sum));
    }

    public Double getAverageCPI() {
        return averageCPI;
    }

    public void setAverageCPI(Double averageCPI) {
        this.averageCPI = averageCPI;
    }

    public Double getCpcPerCamp() {
        return cpcPerCamp;
    }

    public void setCpcPerCamp(Double cpcPerCamp) {
        this.cpcPerCamp = cpcPerCamp;
    }

    public Double getCpcPerFilter() {
        return cpcPerFilter;
    }

    public void setCpcPerFilter(Double cpcPerFilter) {
        this.cpcPerFilter = cpcPerFilter;
    }

    public Double getMaxClickBid() {
        return maxClickBid;
    }

    public void setMaxClickBid(Double maxClickBid) {
        this.maxClickBid = maxClickBid;
    }

    public Double getWeekBid() {
        return weekBid;
    }

    public void setWeekBid(Double weekBid) {
        this.weekBid = weekBid;
    }

    public Double getCpaPerCamp() {
        return cpaPerCamp;
    }

    public void setCpaPerCamp(Double cpaPerCamp) {
        this.cpaPerCamp = cpaPerCamp;
    }

    public Double getCpaPerFilter() {
        return cpaPerFilter;
    }

    public void setCpaPerFilter(Double cpaPerFilter) {
        this.cpaPerFilter = cpaPerFilter;
    }

    public Boolean getIndependentControlStrategy() {
        return isIndependentControlStrategy;
    }

    public void setIndependentControlStrategy(Boolean independentControlStrategy) {
        isIndependentControlStrategy = independentControlStrategy;
    }

    public Double getMaxPrice() {
        return maxPrice;
    }

    public void setMaxPrice(Double sum) {
        this.maxPrice = sum;
        if(sum != null) {
            this.averagePrice = null;
        }
    }

    public Double getAveragePrice() {
        return averagePrice;
    }

    public void setAveragePrice(Double sum) {
        this.averagePrice = sum;
        if(sum != null) {
            this.maxPrice = null;
        }
    }

    public Double getWeeklySumLimit() {
        return weeklySumLimit;
    }

    public void setWeeklySumLimit(Double weeklySumLimit) {
        this.weeklySumLimit = weeklySumLimit;
    }

    public Integer getClicksPerWeek() {
        return clicksPerWeek;
    }

    public void setClicksPerWeek(Integer clicksPerWeek) {
        this.clicksPerWeek = clicksPerWeek;
    }

    public String getStrategyName() {
        return strategyName;
    }

    public void setStrategyName(String strategyName) {
        this.strategyName = strategyName;
    }

    public Double getAverageCPA() {
        return averageCPA;
    }

    public void setAverageCPA(Double averageCPA) {
        this.averageCPA = averageCPA;
    }

    public Integer getGoalID() {
        return goalID;
    }

    public void setGoalID(Integer goalID) {
        this.goalID = goalID;
    }

    public Integer getReserveReturn() {
        return reserveReturn;
    }

    public void setReserveReturn(Integer reserveReturn) {
        this.reserveReturn = reserveReturn;
    }

    public Double getROICoef() {
        return ROICoef;
    }

    public void setROICoef(Double ROICoef) {
        this.ROICoef = ROICoef;
    }

    public Double getProfitability() {
        return profitability;
    }

    public void setProfitability(Double profitability) {
        this.profitability = profitability;
    }

    public String getContextLimit() {
        return contextLimit;
    }

    public void setContextLimit(String contextLimit) {
        this.contextLimit = contextLimit;
    }

    public Integer getContextLimitSum() {
        return contextLimitSum;
    }

    public void setContextLimitSum(Integer contextLimitSum) {
        this.contextLimitSum = contextLimitSum;
    }

    public Integer getContextPricePercent() {
        return contextPricePercent;
    }

    public void setContextPricePercent(Integer contextPricePercent) {
        this.contextPricePercent = contextPricePercent;
    }
}
