package ru.yandex.autotests.direct.utils.textresource;

import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.autotests.direct.utils.DirectUtilsException;
import ru.yandex.autotests.direct.utils.beans.PropertyLoaderException;
import ru.yandex.autotests.direct.utils.beans.TextResourceBean;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: alexey-n
 */
public class TextResources {
    private static Logger log = LoggerFactory.getLogger(TextResources.class);

    private static TextResourcesMongoHelper MONGO;
    private static final String COLLECTION_NAME = "resources";

    static {
        MONGO = new TextResourcesMongoHelper();
    }

    private static Map<String, TextResourceBean> getTextCache = new HashMap<>();

    public static String getText(ITextResource textResource, String locale) {
        return getText(textResource, locale, false);
    }

    public static String getText(ITextResource textResource, String locale, boolean allowCaching) {
        String result = null;
        String key = getKey(textResource);
        log.info("Resource Key: " + key);
        TextResourceBean bean = null;
        try {
            if (allowCaching) {
                if (getTextCache.containsKey(key)) {
                    log.info("from cache: " + key);
                    bean = getTextCache.get(key);
                } else {
                    log.info("retrieving: " + key);
                    bean = MONGO.getTextResource(key);
                    getTextCache.put(key, bean);
                }
            } else {
                bean = MONGO.getTextResource(key);
            }
            result = (String) PropertyUtils.getProperty(bean, locale);
        } catch (PropertyLoaderException e) {
            throw new DirectUtilsException("Не удалось получить данные из монго для " + key, e);
        } catch (InvocationTargetException | NoSuchMethodException | IllegalAccessException e) {
            throw new DirectUtilsException(e);
        }
        if (result == null) {
            throw new DirectUtilsException("Нет данных для локали " + locale + " в " + key);
        }
        return result;
    }

    //TODO: перенести в ITextResource, когда появится в java реализация в интерфейсах
    public static String getKey(ITextResource textResource) {
        return textResource.getBundle() + "." + textResource.name();
    }

    public static void saveTextResource(TextResourceBean bean, String key) {
        bean.setKey(key);
        MONGO.addMongoBean(bean);
    }

    //Используется Рукояточником.
    public static TextResourceBean getBean(String key) {
        TextResourceBean bean = null;
        try {
            bean = MONGO.getTextResource(key);
        } catch (PropertyLoaderException e) {
            throw new DirectUtilsException("Не удалось получить текстовые ресурсы из монго по ключу " + key, e);
        }
        return bean;
    }

    //Используется Рукояточником.
    public static List<TextResourceBean> searchBeans(TextResourceBean bean) {
        String query = "";
        if(bean.getKey() != null && !bean.getKey().equals("")) {
            query = query.concat("\"key\":{$regex:\"/*" + bean.getKey() + "/*\",$options:\"im\"}");
        } else {
            query = query.concat("key:{$exists:true}");
        }
        if(bean.getRu() != null && !bean.getRu().equals("")){
            query = query.concat(",\"ru\":{$regex:\"/*" + bean.getRu() + "/*\",$options:\"im\"}");
        } else if(bean.getEn()!= null && !bean.getEn().equals("")){
            query = query.concat(",\"en\":{$regex:\"/*" + bean.getEn() + "/*\",$options:\"im\"}");
        }
        try {
            return MONGO.getMongoBeans("{" + query + "}");
        } catch (PropertyLoaderException e) {
            throw new DirectUtilsException("Не удалось найти текстовые ресурсы в монге", e);
        }
    }


}

