package ru.yandex.autotests.direct.utils.textresource;

import ru.yandex.autotests.direct.utils.beans.TextResourceBean;
import ru.yandex.autotests.irt.restheart.config.BaseMongoHelper;
import ru.yandex.autotests.irt.restheart.config.MongoDatabases;

/**
 * Author buhter
 * Date 20.06.14
 */
public class TextResourcesMongoHelper extends BaseMongoHelper<TextResourceBean> {
    private static final String COLLECTION = "TextResources";
    private static final String QUERY_TEMPLATE = "{key:\"%s\"}";

    public TextResourcesMongoHelper() {
        super(TextResourceBean.class);
    }

    public TextResourceBean getTextResource(String key) {
        String query = String.format(QUERY_TEMPLATE, key);
        return getMongoBean(query);
    }

    public void deleteTextResource(String key) {
        String query = String.format(QUERY_TEMPLATE, key);
        deleteMongoBean(query);
    }

    @Override
    public String getUniqueFilter(TextResourceBean bean) {
        return String.format(QUERY_TEMPLATE, bean.getKey());
    }

    @Override
    public String getCollection() {
        return COLLECTION;
    }

    @Override
    public String getDb() {
        return MongoDatabases.BEAN_TEMAPLATES.getDbName();
    }
}

