package ru.yandex.autotests.direct.web.api.config;

import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

@Resource.Classpath("web.api.client.properties")
public class ClientConfig {

    private static ClientConfig INSTANCE;

    private ClientConfig(){};

    public static ClientConfig get() {
        if(INSTANCE == null) {
            INSTANCE = new ClientConfig();
            PropertyLoader.populate(INSTANCE);
        }
        return INSTANCE;
    }

    @Property("web-api.client.timeout.connect")
    private Long connectTimeout;

    @Property("web-api.client.timeout.read")
    private Long readTimeout;

    @Property("web-api.client.timeout.write")
    private Long writeTimeout;

    public Long getConnectTimeout() {
        return connectTimeout;
    }

    public Long getReadTimeout() {
        return readTimeout;
    }

    public Long getWriteTimeout() {
        return writeTimeout;
    }
}
