package ru.yandex.autotests.direct.web.api;

import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

@Resource.Classpath("direct.java.web.api.properties")
public class DirectWebApiProperties {

    private static DirectWebApiProperties properties = null;

    @Property("direct.java.web.api.verbose")
    protected boolean verbose = false;


    private DirectWebApiProperties() {
        PropertyLoader.populate(this);
    }

    public static DirectWebApiProperties getInstance() {
        if (properties == null) {
            properties = new DirectWebApiProperties();
        }

        return properties;
    }

    public boolean isVerbose() {
        return verbose;
    }
}
