package ru.yandex.autotests.direct.web.api.core;

import java.util.HashMap;
import java.util.Map;

import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.spi.LoggingEvent;

import ru.yandex.autotests.irt.testutils.allure.AllureUtils;

public class AllureLogAppender extends AppenderSkeleton {
    private static final String BEGIN_REQUEST_PREFIX = "-->";
    private static final String END_REQUEST_PREFIX = "<-- END";
    private Map<String, StringBuilder> builders = new HashMap<>();
    private boolean append = false;

    @Override
    protected void append(LoggingEvent event) {
        if (event.getLoggerName() == null || !event.getLoggerName().contains(HttpLoggingInterceptor.class.getName())) {
            return;
        }
        if (event.getRenderedMessage().contains(END_REQUEST_PREFIX)) {
            appendToBuilder(event);
            this.append = false;
            AllureUtils.addTextAttachment("request log", this.getBuilder(event.getThreadName()).toString());
            builders.remove(event.getThreadName());
        }
        if (event.getRenderedMessage().contains(BEGIN_REQUEST_PREFIX)) {
            this.append = true;
        }
        if (this.append) {
            appendToBuilder(event);
        }
    }

    private void appendToBuilder(LoggingEvent event) {
        this.getBuilder(event.getThreadName()).append(event.getRenderedMessage()).append("\n");
    }

    private StringBuilder getBuilder(String name) {
        if (!builders.containsKey(name)) {
            builders.put(name, new StringBuilder());
        }
        return builders.get(name);
    }

    @Override
    public void close() {
    }

    @Override
    public boolean requiresLayout() {
        return false;
    }
}
