package ru.yandex.autotests.direct.web.api.core;

import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.direct.web.api.steps.DirectWebApiSteps;

public class AuthRule extends TestWatcher implements NeedsWebApiSteps {

    private DirectWebApiSteps directWebApiSteps;
    private String login;

    public AuthRule(String login) {
        this.login = login;
    }

    @Override
    public DirectWebApiSteps getDirectWebApiSteps() {
        return directWebApiSteps;
    }

    @Override
    public AuthRule withDirectWebApiSteps(DirectWebApiSteps directWebApiSteps) {
        this.directWebApiSteps = directWebApiSteps;
        return this;
    }

    public AuthRule withLogin(String login) {
        this.login = login;
        return this;
    }

    @Override
    protected void starting(Description description) {
        MongoUser user = MongoUser.get(login);
        getDirectWebApiSteps().authoriseAs(user);
    }
}
