package ru.yandex.autotests.direct.web.api.core;

import com.google.gson.Gson;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.direct.web.api.DirectWebApiProperties;
import ru.yandex.autotests.direct.web.api.SimpleCookieJar;
import ru.yandex.autotests.direct.web.api.client.ApiClient;

public class DirectWebApiStepsContext {
    private DirectTestRunProperties properties;
    private ApiClient client;
    private SimpleCookieJar cookieJar;
    private MongoUser currentAuthUser;
    private String csrfToken;

    public DirectWebApiStepsContext withProperties(DirectTestRunProperties properties) {
        this.properties = properties;
        this.cookieJar = new SimpleCookieJar();
        return this;
    }

    public DirectTestRunProperties getProperties() {
        return properties;
    }

    public ApiClient getApiClient() {
        if (client == null) {
            ApiClient.Builder builder = ApiClient.Builder.create()
                    .baseUrl(getBaseUrl())
                    .verbose(DirectWebApiProperties.getInstance().isVerbose())
                    .cookieJar(cookieJar);
            if (currentAuthUser != null) {
                builder.withCsrfTokenSupplier(this::getCsrfToken);
            }
            client = builder.build();
        }
        return client;
    }

    public ApiClient getApiClientWithCustomGson(Gson gson) {
        if (client == null) {
            ApiClient.Builder builder = ApiClient.Builder.create()
                    .baseUrl(getBaseUrl())
                    .verbose(DirectWebApiProperties.getInstance().isVerbose())
                    .cookieJar(cookieJar);
            if (currentAuthUser != null) {
                builder.withCsrfTokenSupplier(this::getCsrfToken);
            }
            client = builder.withGson(gson).build();
        }
        return client;
    }

    public ApiClient createNewApiClientWithCustomGson(Gson gson) {
        ApiClient.Builder builder = ApiClient.Builder.create()
                .baseUrl(getBaseUrl())
                .verbose(DirectWebApiProperties.getInstance().isVerbose())
                .cookieJar(cookieJar);
        if (currentAuthUser != null) {
            builder.withCsrfTokenSupplier(this::getCsrfToken);
        }
        client = builder.withGson(gson).build();
        return client;
    }

    public String getBaseUrl() {
        return "https://" + properties.getDirectCmdHost();
    }

    public String getIntapiBaseUrl() {
        String directIntapiHost = properties.getDirectIntapiHost();
        if (directIntapiHost.contains("test")) {
            directIntapiHost += ":9443";
        }
        return directIntapiHost;
    }

    public SimpleCookieJar getCookieJar() {
        return cookieJar;
    }

    public DirectWebApiStepsContext withCookieJar(SimpleCookieJar cookieJar) {
        this.cookieJar = cookieJar;
        return this;
    }

    public MongoUser getCurrentAuthUser() {
        return currentAuthUser;
    }

    public DirectWebApiStepsContext withCurrentAuthUser(MongoUser currentAuth) {
        this.currentAuthUser = currentAuth;
        return this;
    }

    public String getCsrfToken() {
        return csrfToken;
    }

    public DirectWebApiStepsContext withCsrfToken(String csrfToken) {
        this.csrfToken = csrfToken;
        return this;
    }
}
