package ru.yandex.autotests.direct.web.api.data;

import java.util.Collections;

import ru.yandex.autotests.direct.web.api.models.Condition;
import ru.yandex.autotests.direct.web.api.models.MetrikaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionWeb;

import static ru.yandex.autotests.direct.web.api.data.GoalConstants.GOALS_IDS;

public class RetargetingConditionWebFactory {
    public static RetargetingConditionWeb defaultRetargetingConditionWeb() {
        return new RetargetingConditionWeb()
                .withName("testName" + System.currentTimeMillis())
                .withDescription("testDescription")
                .withConditions(Collections.singletonList(
                        new Condition()
                                .withGoals(Collections.singletonList(new MetrikaGoalWeb()
                                        .withTime(30)
                                        .withId(GOALS_IDS[0])
                                ))
                                .withType(Condition.TypeEnum.ALL)
                ));
    }
}
