package ru.yandex.autotests.direct.web.api.rules;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;

import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.BannersRecord;
import ru.yandex.autotests.direct.db.models.jooq.ppc.tables.records.PhrasesRecord;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;

import static org.hamcrest.Matchers.is;
import static org.junit.Assume.assumeThat;

public abstract class AbstractAdGroupWebApiRule<T extends DirectWebApiRule> extends DirectWebApiRule<T> {
    private Supplier<Long> campaignCreationSupplier;
    protected DirectJooqDbSteps directJooqDbSteps;

    protected long campaignId;
    protected long adGroupId;
    protected long bannerId;

    protected void start() {
        campaignId = campaignCreationSupplier.get();
        saveAdGroup(campaignId);

        List<Long> adGroupIds = directJooqDbSteps.useShardForLogin(getUlogin())
                .adGroupsSteps()
                .getPhrasesByCid(campaignId)
                .stream()
                .map(PhrasesRecord::getPid)
                .collect(Collectors.toList());
        assumeThat("В кампании должна была сохраниться одна группа объявлений",
                adGroupIds.size(), is(1));
        adGroupId = adGroupIds.get(0);

        List<BannersRecord> bannersRecords = directJooqDbSteps.bannersSteps().getBannerByPid(adGroupId);
        assumeThat("В группе должен был сохраниться один баннер",
                bannersRecords.size(), is(1));
        bannerId = bannersRecords.get(0).getBid();
    }

    protected abstract void saveAdGroup(long campaignId);

    protected void finish() {

    }

    protected T withCampaignCreationSupplier(Supplier<Long> campaignCreationSupplier) {
        this.campaignCreationSupplier = campaignCreationSupplier;
        return (T) this;
    }

    protected T withDirectDbJooqSteps(DirectJooqDbSteps directJooqDbSteps) {
        this.directJooqDbSteps = directJooqDbSteps;
        return (T) this;
    }

    public long getCampaignId() {
        return campaignId;
    }

    public long getAdGroupId() {
        return adGroupId;
    }

    public long getBannerId() {
        return bannerId;
    }
}
