package ru.yandex.autotests.direct.web.api.rules;

import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

import ru.yandex.autotests.direct.web.api.core.NeedsWebApiSteps;
import ru.yandex.autotests.direct.web.api.steps.DirectWebApiSteps;

public abstract class DirectWebApiRule<T extends DirectWebApiRule> implements TestRule, NeedsWebApiSteps {
    private String ulogin;
    private boolean testFailed;
    private boolean testBroken;

    private DirectWebApiSteps directWebApiSteps;

    @Override
    public Statement apply(Statement base, Description description) {
        return new Statement() {
            @Override
            public void evaluate() throws Throwable {
                try {
                    start();
                    base.evaluate();
                } catch (AssertionError e) {
                    testFailed = true;
                    throw e;
                } catch (Throwable t) {
                    testBroken = true;
                    throw t;
                } finally {
                    finish();
                }
            }
        };

    }

    protected abstract void start();

    protected abstract void finish();

    @Override
    public DirectWebApiSteps getDirectWebApiSteps() {
        return directWebApiSteps;
    }

    @Override
    public NeedsWebApiSteps withDirectWebApiSteps(DirectWebApiSteps directWebApiSteps) {
        this.directWebApiSteps = directWebApiSteps;
        return this;
    }

    public T withUlogin(String ulogin) {
        this.ulogin = ulogin;
        return (T) this;
    }

    public String getUlogin() {
        return ulogin;
    }
}
