package ru.yandex.autotests.direct.web.api.rules;

import java.util.Collections;

import ru.yandex.autotests.direct.web.api.models.RetargetingConditionActionResponse;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionWeb;

import static ru.yandex.autotests.direct.web.api.data.RetargetingConditionWebFactory.defaultRetargetingConditionWeb;

public class RetargetingConditionRule extends DirectWebApiRule<RetargetingConditionRule> {

    private Long retCondId;


    protected void start() {
        createRetargeting();
    }

    protected void finish() {
        getDirectWebApiSteps().retargetingSteps()
                .deleteRetargetingCondition(Collections.singletonList(retCondId), getUlogin());
    }

    private Long createRetargeting() {
        RetargetingConditionWeb request = defaultRetargetingConditionWeb();
        RetargetingConditionActionResponse result =
                getDirectWebApiSteps().retargetingSteps().createRetargetingCondition(request, getUlogin());

        retCondId = result.getId();
        return retCondId;
    }

    public Long getRetCondId() {
        return retCondId;
    }
}
