package ru.yandex.autotests.direct.web.api.steps;

import java.util.List;

import ru.yandex.autotests.direct.web.api.CampaignApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.DeleteCampMetrikaCountersWebRequest;
import ru.yandex.autotests.direct.web.api.models.UpdateCampMetrikaCountersWebRequest;
import ru.yandex.autotests.direct.web.api.models.WebSuccessResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class CampaignSteps extends DirectWebApiBaseSteps<CampaignApi> {

    public CampaignSteps() {
        super(CampaignApi.class);
    }


    @Step("Campaign: добавление счетчиков метрики в кампании")
    public WebSuccessResponse addMetrikaCounters(List<Long> cids, List<Long> metrikaCounters, String ulogin) {
        UpdateCampMetrikaCountersWebRequest request = new UpdateCampMetrikaCountersWebRequest()
                .withCids(cids)
                .withMetrikaCounters(metrikaCounters);
        return addMetrikaCounters(request, ulogin);
    }

    @Step("Campaign: добавление счетчиков метрики в кампании")
    public WebSuccessResponse addMetrikaCounters(UpdateCampMetrikaCountersWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().addMetrikaCounters(request, ulogin)).body();
    }

    @Step("Campaign: замена счетчиков метрики в кампаниях")
    public WebSuccessResponse replaceMetrikaCounters(List<Long> cids, List<Long> metrikaCounters, String ulogin) {
        UpdateCampMetrikaCountersWebRequest request = new UpdateCampMetrikaCountersWebRequest()
                .withCids(cids)
                .withMetrikaCounters(metrikaCounters);
        return replaceMetrikaCounters(request, ulogin);
    }

    @Step("Campaign: замена счетчиков метрики в кампаниях")
    public WebSuccessResponse replaceMetrikaCounters(UpdateCampMetrikaCountersWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().replaceMetrikaCounters(request, ulogin)).body();
    }

    @Step("Campaign: удаление счетчиков метрики из кампаний")
    public WebSuccessResponse deleteMetrikaCounters(List<Long> cids, String ulogin) {
        DeleteCampMetrikaCountersWebRequest request = new DeleteCampMetrikaCountersWebRequest()
                .withCids(cids);
        return deleteMetrikaCounters(request, ulogin);
    }

    @Step("Campaign: удаление счетчиков метрики из кампаний")
    public WebSuccessResponse deleteMetrikaCounters(DeleteCampMetrikaCountersWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().deleteMetrikaCounters(request, ulogin)).body();
    }
}
