package ru.yandex.autotests.direct.web.api.steps;

import retrofit2.Response;

import ru.yandex.autotests.direct.web.api.ContentpromotionApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.GetContentPromotionMetaRequest;
import ru.yandex.autotests.direct.web.api.models.GetContentPromotionMetaResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class ContentPromotionSteps extends DirectWebApiBaseSteps<ContentpromotionApi> {

    public ContentPromotionSteps() {
        super(ContentpromotionApi.class);
    }

    @Step("ContentPromotion: получение метаданных продвигаемого контента")
    public Response<GetContentPromotionMetaResponse> getMeta(GetContentPromotionMetaRequest request,
                                                             String clientLogin) {
        return execute(getOrCreateApiService().getContentPromotionMeta(request, clientLogin));
    }
}
