package ru.yandex.autotests.direct.web.api.steps;

import java.util.List;

import ru.yandex.autotests.direct.web.api.CryptaApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.CryptaGoalWeb;
import ru.yandex.qatools.allure.annotations.Step;

public class CryptaSteps extends DirectWebApiBaseSteps<CryptaApi> {
    public CryptaSteps() {
        super(CryptaApi.class);
    }

    @Step("Retargeting: получение сегментов крипты для ретаргетинга")
    public List<CryptaGoalWeb> getGoals(String type, String filter, String lang) {
        return executeSafe(getOrCreateApiService().getCryptaSegments(type, filter, lang)).body().getResult();
    }
}
