package ru.yandex.autotests.direct.web.api.steps;

import java.util.List;

import ru.yandex.autotests.direct.web.api.DealApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.DealsChangeStatusResponse;
import ru.yandex.autotests.direct.web.api.models.GetDealsDetailsResponse;
import ru.yandex.autotests.direct.web.api.models.GetDealsListResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class DealSteps extends DirectWebApiBaseSteps<DealApi> {
    public DealSteps() {
        super(DealApi.class);
    }

    @Step("Deal: активация сделки")
    public DealsChangeStatusResponse activateDeals(List<Long> dealIds, String login) {
        return executeSafe(getOrCreateApiService().activateDeals(dealIds, login)).body();
    }

    @Step("Deal: архивация сделки")
    public DealsChangeStatusResponse archiveDeals(List<Long> dealIds, String login) {
        return executeSafe(getOrCreateApiService().archiveDeals(dealIds, login)).body();
    }

    @Step("Deal: завершение сделки")
    public DealsChangeStatusResponse completeDeals(List<Long> dealIds, String login) {
        return executeSafe(getOrCreateApiService().completeDeals(dealIds, login)).body();
    }

    @Step("Deal: получение сделок по ids")
    public GetDealsDetailsResponse getDealsDetails(List<Long> dealIds, String login) {
        return executeSafe(getOrCreateApiService().getDealsDetails(dealIds, login)).body();
    }

    @Step("Deal: получение всех доступных сделок")
    public GetDealsListResponse getDealsList(String login) {
        return getDealsList(login, null, null);
    }

    @Step("Deal: получение всех доступных сделок с сортировкой")
    public GetDealsListResponse getDealsList(String login, String sortBy, String sortOrder) {
        return executeSafe(getOrCreateApiService().getDealsList(sortBy, sortOrder, null, login)).body();
    }
}
