package ru.yandex.autotests.direct.web.api.steps;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;

import ru.yandex.autotests.direct.web.api.DealtestApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.Deal;
import ru.yandex.autotests.direct.web.api.models.Percent;

public class DealTestSteps extends DirectWebApiBaseSteps<DealtestApi> {
    public DealTestSteps() {
        super(DealtestApi.class);
    }

    public List<Deal> addRandomDeals(Long dealsNumber, String login) {
        return executeSafe(getOrCreateApiService().addRandomDeals(dealsNumber, login)).body().getResult();
    }

    public Deal addRandomDeal(String login) {
        return executeSafe(getOrCreateApiService().addRandomDeal(login)).body().getResult();
    }

    public void complete(List<Long> dealsIds, String reason, String login) {
        executeSafe(getOrCreateApiService().completeWithReason(dealsIds, reason, login));
    }

    @Override
    protected DealtestApi getOrCreateApiService() {
        if (super.getApiService() == null) {
            DateTimeFormatter DATEFORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            Gson gson = (new GsonBuilder()).registerTypeAdapter(LocalDateTime.class,
                    (JsonDeserializer) (json, type, jsonDeserializationContext) -> {
                        LocalDate ld = LocalDate.parse(json.getAsJsonPrimitive().getAsString(), DATEFORMATTER);
                        return LocalDateTime.of(ld, LocalDateTime.now().toLocalTime());
                    }).registerTypeAdapter(Percent.class,
                    (JsonDeserializer) (jsonElement, type, jsonDeserializationContext) -> new Percent()).create();

            this.withApiService(getContext().getApiClientWithCustomGson(gson).createService(getApiServiceClass()));
        }
        return super.getOrCreateApiService();
    }
}
