package ru.yandex.autotests.direct.web.api.steps;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.autotests.direct.utils.BaseSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.model.MongoUser;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiStepsContext;

public class DirectWebApiSteps {

    private static final Logger LOG = LoggerFactory.getLogger(DirectWebApiSteps.class);
    private DirectWebApiStepsContext context;

    public DirectWebApiSteps(DirectTestRunProperties properties) {
        this.context = new DirectWebApiStepsContext().withProperties(properties);
    }

    public DirectWebApiSteps() {
        this(DirectTestRunProperties.getInstance());
    }

    public RetargetingSteps retargetingSteps() {
        return BaseSteps.getInstance(RetargetingSteps.class, context);
    }

    public CryptaSteps cryptaSteps() {
        return BaseSteps.getInstance(CryptaSteps.class, context);
    }

    public MinusKeywordSteps minusKeywordSteps() {
        return BaseSteps.getInstance(MinusKeywordSteps.class, context);
    }

    public KeywordStatSteps keywordStatSteps() {
        return BaseSteps.getInstance(KeywordStatSteps.class, context);
    }

    public CampaignSteps campaignSteps() {
        return BaseSteps.getInstance(CampaignSteps.class, context);
    }

    public DealSteps dealSteps() {
        return BaseSteps.getInstance(DealSteps.class, context);
    }

    public DealTestSteps dealTestSteps() {
        return BaseSteps.getInstance(DealTestSteps.class, context);
    }

    public RetargetingCraftedSteps retargetingCraftedSteps() {
        return BaseSteps.getInstance(RetargetingCraftedSteps.class, context);
    }

    public VcardSteps vcardSteps() {
        return BaseSteps.getInstance(VcardSteps.class, context);
    }

    public AutoOverdraftSteps autoOverdraftSteps() {
        return BaseSteps.getInstance(AutoOverdraftSteps.class, context);
    }

    public MobileAppSteps mobileAppSteps() {
        return BaseSteps.getInstance(MobileAppSteps.class, context);
    }

    public MediareachSteps mediareachSteps() {
        return BaseSteps.getInstance(MediareachSteps.class, context);
    }

    public ContentPromotionSteps contentPromotionSteps() {
        return BaseSteps.getInstance(ContentPromotionSteps.class, context);
    }

    public void authoriseAs(MongoUser user) {
        BaseSteps.getInstance(AuthSteps.class, context).authorise(user);
    }

    public Logger log() {
        return LOG;
    }
}
