package ru.yandex.autotests.direct.web.api.steps;

import ru.yandex.autotests.direct.web.api.KeywordstatshowscontrollerApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.KeywordStatShowsRequest;
import ru.yandex.autotests.direct.web.api.models.KeywordStatShowsResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class KeywordStatSteps extends DirectWebApiBaseSteps<KeywordstatshowscontrollerApi> {

    public KeywordStatSteps()
    {
        super(KeywordstatshowscontrollerApi.class);
    }

    public KeywordStatShowsResponse getKeywordStatShows(String geo, String phrase) {
        return getKeywordStatShows(new KeywordStatShowsRequest().withGeo(geo).withPhrase(phrase));
    }

    @Step("Keywords: получение статистики по фразе")
    public KeywordStatShowsResponse getKeywordStatShows(KeywordStatShowsRequest request) {
        return executeSafe(getOrCreateApiService().keywordsStatShows(request)).body();
    }
}
