package ru.yandex.autotests.direct.web.api.steps;

import java.time.LocalDate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializer;

import ru.yandex.autotests.direct.web.api.MediareachApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.CpmForecastRequest;
import ru.yandex.autotests.direct.web.api.models.CpmForecastResponse;
import ru.yandex.autotests.direct.web.api.models.CpmTrafficLightPredictionResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class MediareachSteps extends DirectWebApiBaseSteps<MediareachApi> {

    public MediareachSteps() {
        super(MediareachApi.class);
    }

    @Step("Mediareach: получение прогноза cpm по кампании")
    public CpmForecastResponse getCampaignForecast(CpmForecastRequest request, String login) {
        return executeSafe(getOrCreateApiService().getCampaignForecast(request, login)).body();
    }

    @Step("Mediareach: получение цвета светофора и рекомендуемого cpm по кампании")
    public CpmTrafficLightPredictionResponse getCpmTrafficLightPrediction(CpmForecastRequest request, String login) {
        return executeSafe(getOrCreateApiService().getCpmTrafficLightPrediction(request, login)).body();
    }

    @Override
    protected MediareachApi getOrCreateApiService() {
        if (super.getApiService() == null) {
            Gson gson = new GsonBuilder().registerTypeAdapter(LocalDate.class,
                    (JsonSerializer) (source, type, jsonSerializationContext) -> {
                        LocalDate localDate = (LocalDate) source;
                        return new JsonPrimitive(localDate.toString());
                    }).create();
            this.withApiService(getContext().getApiClientWithCustomGson(gson).createService(getApiServiceClass()));
        }
        return super.getOrCreateApiService();
    }
}
