package ru.yandex.autotests.direct.web.api.steps;

import ru.yandex.autotests.direct.web.api.MinusKeywordApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.AddMinusKeywordsRequest;
import ru.yandex.autotests.direct.web.api.models.CheckMinusKeywordsInclusionRequest;
import ru.yandex.autotests.direct.web.api.models.WebSuccessResponse;
import ru.yandex.qatools.allure.annotations.Step;

public class MinusKeywordSteps extends DirectWebApiBaseSteps<MinusKeywordApi> {

    public MinusKeywordSteps() {
        super(MinusKeywordApi.class);
    }


    @Step("MinusKeywords: добавление минус-фраз на кампании и группы")
    public WebSuccessResponse addMinusKeywords(AddMinusKeywordsRequest addMinusKeywordsRequest, String ulogin) {
        return executeSafe(getOrCreateApiService().addMinusKeywords(addMinusKeywordsRequest, ulogin)).body();
    }

    @Step("MinusKeyword: проверка включения минус-фразы в ключевую фразу, логин: {1}, запрос: {0}")
    public Boolean getGoals(CheckMinusKeywordsInclusionRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().checkKeywordInclusion(request, ulogin)).body().getSuccess();
    }
}
