package ru.yandex.autotests.direct.web.api.steps;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializer;

import ru.yandex.autotests.direct.web.api.RetargetingCraftedApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.AbstractGoalWeb;
import ru.yandex.autotests.direct.web.api.models.CryptaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.MetrikaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionWeb;
import ru.yandex.qatools.allure.annotations.Step;

import static java.util.stream.Collectors.toSet;

public class RetargetingCraftedSteps extends DirectWebApiBaseSteps<RetargetingCraftedApi> {
    public RetargetingCraftedSteps() {
        super(RetargetingCraftedApi.class);
    }

    @Step("Retargeting: получение условий ретаргетинга, логин: {4}")
    public List<RetargetingConditionWeb> getConditions(List<Long> retargetingConditionIds, List<Long> adGroupIds,
            String filter, String type, String ulogin) {
        return executeSafe(getOrCreateApiService().ajaxGetRetCondWithGoals(retargetingConditionIds,
                adGroupIds, filter, type, ulogin)).body().getResult();
    }

    private static final Set<String> METRICA_GOAL_TYPES = Collections.unmodifiableSet(
            Stream.of(
                    AbstractGoalWeb.TypeEnum.GOAL.name().toLowerCase(),
                    AbstractGoalWeb.TypeEnum.SEGMENT.name().toLowerCase(),
                    AbstractGoalWeb.TypeEnum.ECOMMERCE.name().toLowerCase(),
                    AbstractGoalWeb.TypeEnum.AUDIENCE.name().toLowerCase()).collect(toSet()));

    private static final Set<String> DIRECT_GOAL_TYPES = Collections.unmodifiableSet(
            Stream.of(
                    AbstractGoalWeb.TypeEnum.LAL_SEGMENT.name().toLowerCase()).collect(toSet()));

    @Override
    protected RetargetingCraftedApi getOrCreateApiService() {
        final Gson gson = new GsonBuilder()
                .registerTypeAdapter(AbstractGoalWeb.class,
                        (JsonDeserializer) (json, type, context) -> {
                            final String goalType =
                                    json.getAsJsonObject().get("type").getAsString();
                            return METRICA_GOAL_TYPES.contains(goalType) || DIRECT_GOAL_TYPES.contains(goalType)
                                    ? context.deserialize(json, MetrikaGoalWeb.class)
                                    : context.deserialize(json, CryptaGoalWeb.class);
                        })
                .create();

        return getContext().createNewApiClientWithCustomGson(gson).createService(getApiServiceClass());
    }

}
