package ru.yandex.autotests.direct.web.api.steps;

import java.util.List;

import ru.yandex.autotests.direct.web.api.RetargetingApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.MetrikaGoalWeb;
import ru.yandex.autotests.direct.web.api.models.ReplaceGoal;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionActionResponse;
import ru.yandex.autotests.direct.web.api.models.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.api.models.SwitchRetargetingWeb;
import ru.yandex.qatools.allure.annotations.Step;

public class RetargetingSteps extends DirectWebApiBaseSteps<RetargetingApi> {
    public RetargetingSteps() {
        super(RetargetingApi.class);
    }

    @Step("Retargeting: получение целей для ретаргетинга, логин: {0}")
    public List<MetrikaGoalWeb> getGoals(String ulogin) {
        return executeSafe(getOrCreateApiService().getGoalsForRetargeting(ulogin)).body().getResult();
    }

    @Step("Retargeting: создание условия ретаргетинга, логин: {1}")
    public RetargetingConditionActionResponse createRetargetingCondition(
            RetargetingConditionWeb retargetingConditionWeb, String ulogin)
    {
        return executeSafe(getOrCreateApiService().createRetargetingCondition(retargetingConditionWeb, ulogin)).body();
    }

    @Step("Retargeting: обновление условия ретаргетинга, логин: {1}")
    public boolean updateRetargetingCondition(RetargetingConditionWeb retargetingConditionWeb, String ulogin) {
        return executeSafe(getOrCreateApiService().updateRetargetingCondition(retargetingConditionWeb, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: замена целей, логин: {1}")
    public boolean replaceGoalsInRetargetings(List<ReplaceGoal> replaceGoals, String ulogin) {
        return executeSafe(getOrCreateApiService().replaceGoalsInRetargetings(replaceGoals, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: удаление условий ретаргетинга, логин: {1}")
    public boolean deleteRetargetingCondition(List<Long> ids, String ulogin) {
        return executeSafe(getOrCreateApiService().deleteRetargetingCondition(ids, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: выключение условий ретаргетинга, логин: {0}, логин")
    public boolean switchRetargetingConditions(List<SwitchRetargetingWeb> switchRetargetings, String ulogin) {
        return executeSafe(getOrCreateApiService().switchRetargetingConditions(switchRetargetings, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: прогнозирование число посетителей с указанными условием ретаргетинга, логин: {1}")
    public boolean retargetingCondEstimate(RetargetingConditionWeb retargetingConditionWeb, String ulogin) {
        return executeSafe(getOrCreateApiService().retargetingCondEstimate(retargetingConditionWeb, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: выключение условий ретаргетинга, логин: {0}, логин")
    public boolean unsuspendRetargetingConditions(List<Long> ids, String ulogin) {
        return executeSafe(getOrCreateApiService().unsuspendRetargetingConditions(ids, ulogin)).body()
                .getSuccess();
    }

    @Step("Retargeting: выключение условий ретаргетинга, логин: {0}, логин")
    public boolean suspendRetargetingConditions(List<Long> ids, String ulogin) {
        return executeSafe(getOrCreateApiService().suspendRetargetingConditions(ids, ulogin)).body()
                .getSuccess();
    }
}
