package ru.yandex.autotests.direct.web.api.steps;

import java.util.List;

import ru.yandex.autotests.direct.web.api.VcardApi;
import ru.yandex.autotests.direct.web.api.core.DirectWebApiBaseSteps;
import ru.yandex.autotests.direct.web.api.models.AssignVcardWebRequest;
import ru.yandex.autotests.direct.web.api.models.SaveVcardWebRequest;
import ru.yandex.autotests.direct.web.api.models.UnassignVcardWebRequest;
import ru.yandex.autotests.direct.web.api.models.WebSuccessResponse;
import ru.yandex.autotests.direct.web.api.models.WebVcard;
import ru.yandex.qatools.allure.annotations.Step;

public class VcardSteps extends DirectWebApiBaseSteps<VcardApi> {

    public VcardSteps() {
        super(VcardApi.class);
    }

    public WebSuccessResponse saveVcardByBannerIds(
            Long campaignId, List<Long> bannerIds, WebVcard vcard, String ulogin)
    {
        SaveVcardWebRequest request = new SaveVcardWebRequest()
                .withCid(campaignId)
                .withBids(bannerIds)
                .withVcard(vcard);
        return saveVcard(request, ulogin);
    }

    public WebSuccessResponse saveVcardByVcardId(
            Long campaignId, Long vcardId, WebVcard vcard, String ulogin)
    {
        SaveVcardWebRequest request = new SaveVcardWebRequest()
                .withCid(campaignId)
                .withVcardId(vcardId)
                .withBids(null)
                .withVcard(vcard);
        return saveVcard(request, ulogin);
    }

    @Step("Vcard: сохранение визитки в баннерах")
    public WebSuccessResponse saveVcard(SaveVcardWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().saveVcard(request, ulogin)).body();
    }

    public WebSuccessResponse assignVcard(
            Long campaignId, List<Long> bannerIds, Long vcardId, String ulogin)
    {
        AssignVcardWebRequest request = new AssignVcardWebRequest()
                .withCid(campaignId)
                .withBids(bannerIds)
                .withVcardId(vcardId);
        return assignVcard(request, ulogin);
    }

    @Step("Vcard: замена визитки в баннерах")
    public WebSuccessResponse assignVcard(AssignVcardWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().assignVcard(request, ulogin)).body();
    }

    public WebSuccessResponse unassignVcard(
            Long campaignId, List<Long> bannerIds, String ulogin)
    {
        UnassignVcardWebRequest request = new UnassignVcardWebRequest()
                .withCid(campaignId)
                .withBids(bannerIds);
        return unassignVcard(request, ulogin);
    }

    @Step("Vcard: удаление визитки из баннеров")
    public WebSuccessResponse unassignVcard(UnassignVcardWebRequest request, String ulogin) {
        return executeSafe(getOrCreateApiService().unassignVcard(request, ulogin)).body();
    }
}
