package ru.yandex.autotests.direct.web;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;

/**
 * Загрузка свойств проекта из файла
 */
@Resource.Classpath("directweb.properties")
public class DirectWebProperties {

    public DirectWebProperties() {
        PropertyLoader.populate(this);
    }

    @Property("directweb.super")
    private String superLogin;

    @Property("directweb.cookie.mda")
    private String mda;

    @Property("directweb.auth.url")
    private String authUrl = "https://test-direct.yandex.ru";

    @Property("directweb.interface.lang")
    private String interfaceLanguage;

    public String getSuperLogin() {
        return superLogin;
    }

    public Integer getImplicitWait() {
        return DirectTestRunProperties.getInstance().getDirectWebWebdriverImplicityWaitTimeoutSec();
    }

    public String getLocale() {
        return DirectTestRunProperties.getInstance().getDirectCmdLocale();
    }

    public String getMda() {
        return mda;
    }

    public String getAuthUrl() {
        return authUrl;
    }

    public String getInterfaceLanguage() {
        return interfaceLanguage;
    }
}