package ru.yandex.autotests.direct.web;
import ru.yandex.qatools.properties.PropertyLoader;
import ru.yandex.qatools.properties.annotations.Property;
import ru.yandex.qatools.properties.annotations.Resource;
@Resource.Classpath("driver.properties")
public class DriverProperties {
    @Property("driver.browser.name")
    private String name = "chrome";
    @Property("driver.browser.version")
    private String version = "";
    @Property("driver.selenoid.using")
    private boolean selenoidUsing = false;
    public DriverProperties() {
        PropertyLoader.populate(this);
    }
    public String getName() {
        return name;
    }
    public String getVersion() {
        return version;
    }
    public boolean isSelenoidUsing() {
        return selenoidUsing;
    }
}
