package ru.yandex.autotests.direct.web;

import java.net.MalformedURLException;
import java.net.URL;

import org.openqa.selenium.Platform;
import org.openqa.selenium.chrome.ChromeOptions;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;

import ru.yandex.autotests.direct.cmd.DirectCmdSteps;
import ru.yandex.autotests.direct.cmd.data.Logins;
import ru.yandex.autotests.direct.cmd.util.StageSemaphore;
import ru.yandex.autotests.direct.db.steps.DirectJooqDbSteps;
import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.directapi.darkside.steps.DarkSideSteps;
import ru.yandex.autotests.directapi.model.User;
import ru.yandex.autotests.directapi.rules.ApiSteps;
import ru.yandex.autotests.directapi.steps.UserSteps;
import ru.yandex.qatools.allure.webdriver.rules.WebDriverConfiguration;
import ru.yandex.qatools.hazelcast.SemaphoreRule;

public class TestEnvironment {
    /**
     * period in seconds
     */
    protected static DirectWebProperties directWebProperties;

    protected static DriverProperties driverProperties;

    protected static DirectTestRunProperties properties = DirectTestRunProperties.getInstance();

    protected static RemoteWebDriver driver;

    private static DirectJooqDbSteps newDbSteps;

    public static DirectWebProperties getDirectWebProperties() {
        if (directWebProperties == null) {
            directWebProperties = new DirectWebProperties();
        }
        return directWebProperties;
    }

    public static DriverProperties getDriverProperties() {
        if (driverProperties == null) {
            driverProperties = new DriverProperties();
        }
        return driverProperties;
    }

    public static ApiSteps getDirectApi() {
        return new ApiSteps().url(DirectTestRunProperties.getInstance().getDirectAPIHost());
    }

    public static DirectJooqDbSteps newDbSteps() {
        if(newDbSteps == null) {
            newDbSteps = ru.yandex.autotests.direct.httpclient.TestEnvironment.newDbSteps();
        }

        return newDbSteps;
    }

    public static ApiSteps getDirectApi(String userLogin) {
        return getDirectApi().as(userLogin);
    }

    public static SemaphoreRule getSemaphore() {
        return StageSemaphore.getSemaphore(properties.getDirectHost(), properties.getDirectSemaphorePermits());
    }


    public static ru.yandex.autotests.direct.httpclient.UserSteps getHttpClientSteps() {
        return new ru.yandex.autotests.direct.httpclient.UserSteps(properties);
    }

    public static ru.yandex.autotests.direct.httpclient.UserSteps getHttpClientSteps(String login) {
        ru.yandex.autotests.direct.httpclient.UserSteps userSteps =
                new ru.yandex.autotests.direct.httpclient.UserSteps(properties);
        userSteps.onPassport().authoriseAs(login, User.get(login).getPassword());
        return userSteps;
    }

    public static ru.yandex.autotests.direct.httpclient.UserSteps getHttpClientSteps(String login, boolean isGetVars) {
        ru.yandex.autotests.direct.httpclient.UserSteps userSteps =
                new ru.yandex.autotests.direct.httpclient.UserSteps(properties);
        userSteps.onPassport().authoriseAs(login, User.get(login).getPassword());
        return userSteps;
    }

    public static DirectCmdSteps getNewHttpClientSteps(User user) {
        DirectCmdSteps httpUserSteps = new DirectCmdSteps(properties);
        httpUserSteps.authSteps().authenticate(user);
        return httpUserSteps;
    }

    public static DirectCmdSteps getNewHttpClientSteps() {
        return getNewHttpClientSteps(User.get(Logins.SUPER));
    }

    public static UserSteps getApiUserSteps() {
        return getApiSteps().userSteps;
    }

    public static ApiSteps getApiSteps() {
        return getDirectApi(TestEnvironment.getDirectWebProperties().getSuperLogin());
    }

    public static WebDriverConfiguration getWebDriverConfiguration() {
        DesiredCapabilities dc = new DesiredCapabilities(getDriverProperties().getName(),
                getDriverProperties().getVersion(), Platform.ANY);
        return getWebDriverConfiguration(dc);
    }

    public static WebDriverConfiguration getWebDriverConfiguration(DesiredCapabilities dc) {
        String baseUrl = DirectTestRunProperties.getInstance().getDirectCmdHost();

        if (!baseUrl.contains("://")) {
            baseUrl = "https://" + baseUrl;
        }

        try {
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setBrowserName("chrome");
            capabilities.setVersion("89.0");
            capabilities.setCapability("acceptInsecureCerts", true);
            driver = new RemoteWebDriver(new URL("http://direct@sw.yandex-team.ru:80/v0"), capabilities);
        }
        catch (MalformedURLException e) {
            String s = "";
        }

        return new WebDriverConfiguration().usingDriver(driver).usingBaseUrl(baseUrl);
    }

    public static DarkSideSteps getDarkSideSteps() {
        return getApiUserSteps().getDarkSideSteps();
    }
}
