package ru.yandex.autotests.direct.web.data;

import java.util.NoSuchElementException;
import java.util.stream.Stream;

public enum AttributionModelEnum {
    LAST_SIGNIFICANT_CLICK("last_significant_click"),
    LAST_CLICK("last_click"),
    FIRST_CLICK("first_click");

    AttributionModelEnum(String value) {
        this.value = value;
    }

    private String value;

    public String getValue() {
        return value;
    }

    public static AttributionModelEnum getByTextValue(String value) {
        return Stream.of(values())
                .filter(x -> x.getValue().equals(value))
                .findFirst()
                .orElseThrow(NoSuchElementException::new);
    }
}
