package ru.yandex.autotests.direct.web.data;

import java.util.stream.Stream;

public enum BannerPreviewType {
    BASE("base"),
    SEARCH("search"),
    CONTEXT("context"),
    SIZE_728_90("728x90"),
    SIZE_300_250("300x250"),
    SIZE_240_400("240x400");

    private String value;

    BannerPreviewType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return value;
    }

    public String getValue() {
        return this.value;
    }

    public static BannerPreviewType getBannerPreviewTypeByValue(String value) {
        return (BannerPreviewType) Stream.of(values()).filter((t) -> {
            return t.getValue().equals(value);
        }).findFirst().get();
    }
}
