package ru.yandex.autotests.direct.web.data;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getText;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 07.04.14
 */
public enum PaymentTextResources implements ITextResource {

    ON_SHOW_CAMPS_PAYMENT_ERROR,
    ON_SHOW_CAMPS_SERVICED_PAYMENT_ERROR,
    ON_PAYMENT_PAGE_SHORTAGE_ALERT,
    PAYMENT_REQUEST_ACCEPTED_BY_AGENCY_TEXT,
    PAYMENT_INFO_FOR_SUBCLIENT_TEXT,
    YANDEX_MONEY_WAIT_SERVICE_TEXT,
    YANDEX_MONEY_PAGE_TITLE,
    AUTHORIZATION_PAGE_TITLE,
    YANDEX_PAYMENT_SUCCESS;

    private static final String BUNDLE = "web.payment.Payment";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
