package ru.yandex.autotests.direct.web.data;

import java.util.List;

import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;
import ru.yandex.autotests.direct.web.objects.deals.DealInfoWeb;

public class TestLogin {
    private String login;
    private TestLogin manager;
    private TestLogin agency;
    private List<TurboLandingInfoWeb> turboLandings;
    private List<VideoInfoWeb> videos;
    private List<Long> metrikaCounters;
    private List<DealInfoWeb> deals;

    public TestLogin(String login) {
        this.login = login;
    }

    public String getLogin() {
        return login;
    }

    public TestLogin getManager() {
        return manager;
    }

    public TestLogin getAgency() {
        return agency;
    }

    public List<TurboLandingInfoWeb> getTurboLandings() {
        return turboLandings;
    }

    public List<VideoInfoWeb> getVideos() {
        return videos;
    }

    public List<Long> getMetrikaCounters() {
        return metrikaCounters;
    }

    public List<DealInfoWeb> getDeals() {
        return deals;
    }

    public TestLogin withLogin(String login) {
        this.login = login;
        return this;
    }

    public TestLogin withManager(TestLogin managerLogin) {
        this.manager = managerLogin;
        return this;
    }

    public TestLogin withAgency(TestLogin agencyLogin) {
        this.agency = agencyLogin;
        return this;
    }

    public TestLogin withTurboLandings(List<TurboLandingInfoWeb> turboLandings) {
        this.turboLandings = turboLandings;
        return this;
    }
        public TestLogin withVideos(List<VideoInfoWeb> videos) {
            this.videos = videos;
            return this;
    }

    public TestLogin withMetrikaCounters(List<Long> metrikaCounters) {
        this.metrikaCounters = metrikaCounters;
        return this;
    }

    public TestLogin withDeals(List<DealInfoWeb> deals) {
        this.deals = deals;
        return this;
    }
}
