package ru.yandex.autotests.direct.web.data;

import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.VideoInfoWeb;
import ru.yandex.autotests.direct.web.objects.deals.DealInfoWeb;
import ru.yandex.autotests.direct.web.util.EnvironmentWrapper;

import java.util.List;

import static com.google.common.collect.ImmutableList.of;

public class TestLogins {

    public static final TestLogin AT_DIRECT_MNGR_FULL = new TestLogin("at-direct-mngr-full");

    public static final TestLogin AT_DIRECT_SUPPORT = new TestLogin("at-direct-support");

    public static final TestLogin AT_CONTACTINFO_PARAMETERS_C = new TestLogin("at-contactinfo-parameters-c");

    public static final TestLogin AT_CONTACTINFO_PARAMETERS_C_1 = new TestLogin("at-contactinfo-parameters-c-1");

    public static final TestLogin AT_CONTACTINFO_VALIDATION_C = new TestLogin("at-contactinfo-validation-c");

    public static final TestLogin AT_DAYBUDGET_AG = new TestLogin("at-daybudget-ag");

    public static final TestLogin AT_DIRECT_ACT_CAMP_C = new TestLogin("at-direct-act-camp-c");

    public static final TestLogin AT_DIRECT_ADDBANNER_C = new TestLogin("at-direct-addbanner-c");

    public static final TestLogin AT_DIRECT_ADJUSTMENT_RET15 = new TestLogin("at-direct-adjustment-ret15")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_AGENCY = new TestLogin("at-direct-agency")
            .withDeals(
                    new EnvironmentWrapper<List<DealInfoWeb>>()
                            .withEntity(EnvironmentWrapper.Environment.DEVTEST,
                                    of(
                                            new DealInfoWeb()
                                                    .withDealId(2000217L)
                                                    .withDealName("Сделка для at-direct-agency (6)"),
                                            new DealInfoWeb()
                                                    .withDealId(2000216L)
                                                    .withDealName("Сделка для at-direct-agency (4)"),
                                            new DealInfoWeb()
                                                    .withDealId(2000215L)
                                                    .withDealName("Сделка для at-direct-agency (3)")))
                            .withEntity(EnvironmentWrapper.Environment.TS,
                                    of(
                                            new DealInfoWeb()
                                                    .withDealId(2000217L)
                                                    .withDealName("Сделка для at-direct-agency (6)"),
                                            new DealInfoWeb()
                                                    .withDealId(2000216L)
                                                    .withDealName("Сделка для at-direct-agency (4)"),
                                            new DealInfoWeb()
                                                    .withDealId(2000215L)
                                                    .withDealName("Сделка для at-direct-agency (3)")))
                            .getEntity());

    public static final TestLogin AT_DIRECT_AG_NEW_C = new TestLogin("at-direct-ag-new-c");

    public static final TestLogin AT_DIRECT_AG_REPR_1 = new TestLogin("at-direct-ag-repr-1")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_AG_REPR_2 = new TestLogin("at-direct-ag-repr-2")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_AGREPR_A = new TestLogin("at-direct-agrepr-a");

    public static final TestLogin AT_DIRECT_AGREPR_A_REP = new TestLogin("at-direct-agrepr-a-agrepr");

    public static final TestLogin AT_DIRECT_ARCH_SUBCLIENT_A = new TestLogin("at-direct-arch-subclient-a");

    public static final TestLogin AT_DIRECT_ARCH_SUBCLIENT_C1 = new TestLogin("at-direct-arch-subclient-c1");

    public static final TestLogin AT_DIRECT_ARCH_SUBCLIENT_C2 = new TestLogin("at-direct-arch-subclient-c2");

    public static final TestLogin AT_DIRECT_ARCH_SUBCLIENT_C3 = new TestLogin("at-direct-arch-subclient-c3");

    public static final TestLogin AT_DIRECT_BACKEND_C3 = new TestLogin("at-direct-backend-c3");

    public static final TestLogin AT_DIRECT_BACKEND_FEEDS_C = new TestLogin("at-direct-backend-feeds-c");

    public static final TestLogin AT_DIRECT_BANNERMINUSK_C = new TestLogin("at-direct-bannerminusk-c");

    public static final TestLogin AT_DIRECT_BANNERPARAM_C1 = new TestLogin("at-direct-bannerparam-c1");

    public static final TestLogin AT_DIRECT_BANNERPARAM_C2 = new TestLogin("at-direct-bannerparam-c2");

    public static final TestLogin AT_DIRECT_BANNERPARAM_D = new TestLogin("at-direct-bannerparam-d");

    public static final TestLogin AT_DIRECT_BANNERSRC_C = new TestLogin("at-direct-bannersrc-c");

    public static final TestLogin AT_DIRECT_CAMPADDDEL_C = new TestLogin("at-direct-campadddel-c");

    public static final TestLogin AT_DIRECT_CINFO_EDREC_C = new TestLogin("at-direct-cinfo-edrec-c");

    public static final TestLogin AT_DIRECT_CLIENT_REPR_1 = new TestLogin("at-direct-client-repr-1");

    public static final TestLogin AT_DIRECT_CLIENT_REPR_2 = new TestLogin("at-direct-client-repr-2");

    public static final TestLogin AT_DIRECT_COPY_MULTI = new TestLogin("at-direct-copy-multi")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_DEFAPILINK = new TestLogin("at-direct-defapilink");

    public static final TestLogin AT_DIRECT_DELAGREP_A = new TestLogin("at-direct-delagrep-a");

    public static final TestLogin AT_DIRECT_DELAGREP_A_REP_2 = new TestLogin("at-direct-delagrep-a-rep-2");

    public static final TestLogin AT_DIRECT_DELCLREP_C = new TestLogin("at-direct-delclrep-c");

    public static final TestLogin AT_DIRECT_DELCLREP_C_DEL = new TestLogin("at-direct-delclrep-c-del");

    public static final TestLogin AT_DIRECT_DH_BUDGETM2_C = new TestLogin("at-direct-dh-budgetm2-c");

    public static final TestLogin AT_DIRECT_DH_BUDGETM_C = new TestLogin("at-direct-dh-budgetm-c");

    public static final TestLogin AT_DIRECT_DH_CORRECTINTER = new TestLogin("at-direct-dh-correctinter");

    public static final TestLogin AT_DIRECT_DH_DELETE_C = new TestLogin("at-direct-dh-delete-c");

    public static final TestLogin AT_DIRECT_DIFF_TYPES = new TestLogin("at-direct-diff-types");

    public static final TestLogin AT_DIRECT_EDAGREP_A5_REP = new TestLogin("at-direct-edagrep-a5-rep");

    public static final TestLogin AT_DIRECT_EDCLREP_C = new TestLogin("at-direct-edclrep-c");

    public static final TestLogin AT_DIRECT_EDCLREP_C_REP = new TestLogin("at-direct-edclrep-c-rep");

    public static final TestLogin AT_DIRECT_ED_FIRST_HELP_C = new TestLogin("at-direct-ed-first-help-c");

    // agency
    public static final TestLogin AT_DIRECT_EDSUBCLIENT_A = new TestLogin("at-direct-edsubclient-a")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C1 = new TestLogin("at-direct-edsubclient-c1");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C10 = new TestLogin("at-direct-edsubclient-c10");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C11 = new TestLogin("at-direct-edsubclient-c11");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C12 = new TestLogin("at-direct-edsubclient-c12");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C13 = new TestLogin("at-direct-edsubclient-c13");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C14 = new TestLogin("at-direct-edsubclient-c14");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C3 = new TestLogin("at-direct-edsubclient-c3");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C4 = new TestLogin("at-direct-edsubclient-c4");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C5 = new TestLogin("at-direct-edsubclient-c5");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C6 = new TestLogin("at-direct-edsubclient-c6");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C7 = new TestLogin("at-direct-edsubclient-c7");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C8 = new TestLogin("at-direct-edsubclient-c8");

    public static final TestLogin AT_DIRECT_EDSUBCLIENT_C9 = new TestLogin("at-direct-edsubclient-c9");

    public static final TestLogin AT_DIRECT_EXCEL_RMP_C = new TestLogin("at-direct-excel-rmp-c");

    public static final TestLogin AT_DIRECT_FH_ACCEPTREC_C = new TestLogin("at-direct-fh-acceptrec-c");

    public static final TestLogin AT_DIRECT_FH_ACCEPTSEL_C = new TestLogin("at-direct-fh-acceptsel-c");

    public static final TestLogin AT_DIRECT_FH_BANNERPR_C = new TestLogin("at-direct-fh-bannerpr-c");

    public static final TestLogin AT_DIRECT_FH_CANCEL_C = new TestLogin("at-direct-fh-cancel-c");

    public static final TestLogin AT_DIRECT_FH_COPY_CHPARAM = new TestLogin("at-direct-fh-copy-chparam");

    public static final TestLogin AT_DIRECT_FH_COPY_CHPARAM1 = new TestLogin("at-direct-fh-copy-chparam1");

    public static final TestLogin AT_DIRECT_FH_DELETEBLOCK = new TestLogin("at-direct-fh-deleteblock");

    public static final TestLogin AT_DIRECT_FH_MLCOPY_CHPARAM = new TestLogin("at-direct-fh-mlcopy-chparam");

    public static final TestLogin AT_DIRECT_FH_PARAM_C = new TestLogin("at-direct-fh-param-c");

    public static final TestLogin AT_DIRECT_FH_PARAM_C1 = new TestLogin("at-direct-fh-param-c1");

    public static final TestLogin AT_DIRECT_FH_PARAM_C2 = new TestLogin("at-direct-fh-param-c2");

    public static final TestLogin AT_DIRECT_FH_PH_DECLINE_C = new TestLogin("at-direct-fh-ph-decline-c");

    public static final TestLogin AT_DIRECT_FH_PH_POSITION_C = new TestLogin("at-direct-fh-ph-position-c");

    public static final TestLogin AT_DIRECT_FH_SPLIT_C = new TestLogin("at-direct-fh-split-c");

    public static final TestLogin AT_DIRECT_FH_VALID_C = new TestLogin("at-direct-fh-valid-c");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C1 = new TestLogin("at-direct-firsthelp-c1");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C2 = new TestLogin("at-direct-firsthelp-c2");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C3 = new TestLogin("at-direct-firsthelp-c3");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C4 = new TestLogin("at-direct-firsthelp-c4");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C5 = new TestLogin("at-direct-firsthelp-c5");

    public static final TestLogin AT_DIRECT_FIRSTHELP_C6 = new TestLogin("at-direct-firsthelp-c6");

    public static final TestLogin AT_DIRECT_FIRSTHELPSLINKS_C = new TestLogin("at-direct-firsthelpslinks-c");

    public static final TestLogin AT_DIRECT_GROUP_SLINKS_C = new TestLogin("at-direct-group-slinks-c")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_LABEL_C = new TestLogin("at-direct-label-c");

    public static final TestLogin AT_DIRECT_LIGHT_SWITCH_C5 = new TestLogin("at-direct-light-switch-c5");

    public static final TestLogin AT_DIRECT_MEDIAPLANSLINKS_C = new TestLogin("at-direct-mediaplanslinks-c")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_MINUSKEYWS_C = new TestLogin("at-direct-minuskeyws-c");

    public static final TestLogin AT_DIRECT_MISSPELLS = new TestLogin("at-direct-misspells");

    public static final TestLogin AT_DIRECT_NEW_REPR_C = new TestLogin("at-direct-new-repr-c");

    public static final TestLogin AT_DIRECT_NEW_REPR_C_1 = new TestLogin("at-direct-new-repr-c-1");

    public static final TestLogin AT_DIRECT_PARAMVALID_C = new TestLogin("at-direct-paramvalid-c");

    public static final TestLogin AT_DIRECT_PERF_CAMPADDDEL = new TestLogin("at-direct-perf-campadddel");

    public static final TestLogin AT_DIRECT_PERF_GR = new TestLogin("at-direct-perf-gr");

    public static final TestLogin AT_DIRECT_PERF_GROUP3 = new TestLogin("at-direct-perf-group3");

    public static final TestLogin AT_DIRECT_PH_ACCPRICEPOS_C = new TestLogin("at-direct-ph-accpricepos-c");

    public static final TestLogin AT_DIRECT_PH_ADDBANNER_C = new TestLogin("at-direct-ph-addbanner-c");

    public static final TestLogin AT_DIRECT_PHMASSACT_C = new TestLogin("at-direct-phmassact-c");

    public static final TestLogin AT_DIRECT_PH_MINUSKW_C = new TestLogin("at-direct-ph-minuskw-c");

    public static final TestLogin AT_DIRECT_PRICECONSTR_C = new TestLogin("at-direct-priceconstr-c");

    public static final TestLogin AT_DIRECT_SANDBOX_CLIENT = new TestLogin("at-direct-sandbox-client");

    public static final TestLogin AT_DIRECT_SANDBOX_USER = new TestLogin("at-direct-sandbox-user");

    // agency
    public static final TestLogin AT_DIRECT_SEARCH_A2 = new TestLogin("at-direct-search-a2")
            .withManager(AT_DIRECT_MNGR_FULL);;

    public static final TestLogin AT_DIRECT_SEARCH_C3 = new TestLogin("at-direct-search-c3")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_A = new TestLogin("at-direct-setcltoagrep-a");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_A1 = new TestLogin("at-direct-setcltoagrep-a1");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C1 = new TestLogin("at-direct-setcltoagrep-c1");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C12 = new TestLogin("at-direct-setcltoagrep-c12");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C2 = new TestLogin("at-direct-setcltoagrep-c2");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C22 = new TestLogin("at-direct-setcltoagrep-c22");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C3 = new TestLogin("at-direct-setcltoagrep-c3");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C32 = new TestLogin("at-direct-setcltoagrep-c32");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C4 = new TestLogin("at-direct-setcltoagrep-c4");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_C42 = new TestLogin("at-direct-setcltoagrep-c42");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_R = new TestLogin("at-direct-setcltoagrep-r");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_R1 = new TestLogin("at-direct-setcltoagrep-r1");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_R12 = new TestLogin("at-direct-setcltoagrep-r12");

    public static final TestLogin AT_DIRECT_SETCLTOAGREP_R2 = new TestLogin("at-direct-setcltoagrep-r2");

    public static final TestLogin AT_DIRECT_SHOWSUBCLIENTCAMP_A = new TestLogin("at-direct-showsubclientcamp-a");

    public static final TestLogin AT_DIRECT_SHOWSUBCLIENTCAMP_C2 = new TestLogin("at-direct-showsubclientcamp-c2");

    public static final TestLogin AT_DIRECT_SHOWSUBCLIENTCAMP_C3 = new TestLogin("at-direct-showsubclientcamp-c3");

    public static final TestLogin AT_DIRECT_SHOWSUBCLIENTCAMP_C4 = new TestLogin("at-direct-showsubclientcamp-c4");

    public static final TestLogin AT_DIRECT_SHOWSUBCLIENTCAMP_C5 = new TestLogin("at-direct-showsubclientcamp-c5");

    public static final TestLogin AT_DIRECT_SUBCLIENT3 = new TestLogin("at-direct-subclient3");

    public static final TestLogin AT_DIRECT_TEXTGRCHANG_C = new TestLogin("at-direct-textgrchang-c");

    public static final TestLogin AT_DIRECT_TRANSFER_KZT = new TestLogin("at-direct-transfer-kzt");

    public static final TestLogin AT_DIRECT_TRANSFER_TRY = new TestLogin("at-direct-transfer-try");

    public static final TestLogin AT_DIRECT_TRANSFER_UAH = new TestLogin("at-direct-transfer-uah");

    public static final TestLogin AT_DIRECT_TRANSL_C = new TestLogin("at-direct-transl-c");

    public static final TestLogin AT_DIRECT_TRANSLOCUA_C = new TestLogin("at-direct-translocua-c");

    public static final TestLogin AT_DIRECT_VIEWSLINK_C = new TestLogin("at-direct-viewslink-c");

    public static final TestLogin AT_DIRECT_WEB_ADJ1 = new TestLogin("at-direct-web-adj1");

    public static final TestLogin AT_DIRECT_WEB_ADJ2 = new TestLogin("at-direct-web-adj2")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_WEB_ADJ3 = new TestLogin("at-direct-web-adj3");

    public static final TestLogin AT_DIRECT_WEB_ADJ5 = new TestLogin("at-direct-web-adj5");

    public static final TestLogin AT_DIRECT_WEB_CAPTCHA = new TestLogin("at-direct-web-captcha");

    public static final TestLogin AT_DIRECT_WEB_RUS_OS = new TestLogin("at-direct-web-rus-os");

    public static final TestLogin AT_DIRECT_WEB_RUS_OS2 = new TestLogin("at-direct-web-rus-os2");

    public static final TestLogin AT_DIRECT_WEB_RUS_OS3 = new TestLogin("at-direct-web-rus-os3");

    public static final TestLogin AT_DIRECT_WEB_RUS_OS_YM = new TestLogin("at-direct-web-rus-os-ym");

    public static final TestLogin AT_DIRECT_YND_CSV = new TestLogin("at-direct-ynd-csv");

    public static final TestLogin AT_DYNAMIC_CAMPAIGN_TESTER = new TestLogin("at-dynamic-campaign-tester");

    public static final TestLogin AT_FIRSTHELP_CLIENT = new TestLogin("at-firstHelp-client");

    public static final TestLogin AT_FIRSTHELP_CLIENT1 = new TestLogin("at-firstHelp-client1");

    public static final TestLogin AT_FIRSTHELP_OPTIMIZE_C = new TestLogin("at-firsthelp-optimize-c");

    public static final TestLogin AT_PERFORMANCE_GROUP_CHANGES = new TestLogin("at-performance-group-changes");

    public static final TestLogin AT_SERV_ROI_SORTING = new TestLogin("at-serv-roi-sorting")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_SHOWCAMPS_ATTRIBUTE_CLIENT = new TestLogin("at-showcamps-attribute-client");

    public static final TestLogin AT_SHOWCAMPS_SORTPARAM_CLIENT = new TestLogin("at-showcamps-sortparam-client");

    public static final TestLogin AT_SHOWCAMPS_SORTPOPUP_CLIENT = new TestLogin("at-showcamps-sortpopup-client");

    public static final TestLogin AT_SHOWCAMPS_SORT_STRAT_CLIENT = new TestLogin("at-showcamps-sort-strat-client");

    public static final TestLogin AT_SHOWCAMPS_SORTTABLE_CLIENT = new TestLogin("at-showcamps-sorttable-client");

    public static final TestLogin AT_SHOWCAMPS_STATE_CLIENT = new TestLogin("at-showcamps-state-client");

    public static final TestLogin AT_TESTER1 = new TestLogin("at-tester1");

    public static final TestLogin AT_TESTER_ACTIONLINKS = new TestLogin("at-tester-actionlinks");

    public static final TestLogin AT_TESTER_CANVAS_WEB = new TestLogin("at-tester-canvas-web");

    public static final TestLogin AT_TESTER_CURRENCY_RUS = new TestLogin("at-tester-currency-rus");

    public static final TestLogin AT_TESTER_RESUMESTOP_CAMP = new TestLogin("at-tester-resumestop-camp");

    public static final TestLogin AT_TESTER_RETARGETING_PRICES = new TestLogin("at-tester-retargeting-prices");

    public static final TestLogin AT_TIMETARGETING_C1 = new TestLogin("at-timetargeting-c1");

    public static final TestLogin AT_TIMETARGETING_C2 = new TestLogin("at-timetargeting-c2");

    public static final TestLogin AT_TRANSFER_NOPAIDCAMPAIGNS_CL = new TestLogin("at-transfer-nopaidcampaigns-cl");

    public static final TestLogin AT_PRICECONSTRUCTOR_C2 = new TestLogin("at-priceconstructor-c2");

    public static final TestLogin AT_DIRECT_MNGR_GRCHANGES_C = new TestLogin("at-direct-mngr-grchanges-c")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_COPY_1 = new TestLogin("at-direct-copy-1");

    public static final TestLogin AT_DIRECT_FEEDS_C4 = new TestLogin("at-direct-feeds-c4");

    public static final TestLogin AT_SHOWCAMPS_MASSACTION_CLIENT = new TestLogin("at-showcamps-massaction-client");

    public static final TestLogin AT_DIRECT_IMAGE_AD = new TestLogin("at-direct-image-ad");

    public static final TestLogin AT_DIRECT_MC_BANNER_TESTER_1 = new TestLogin("at-direct-mc-banner-tester-1");

    public static final TestLogin AT_SERV_ROI = new TestLogin("at-serv-roi")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_SERV_CPI = new TestLogin("at-serv-cpi");

    public static final TestLogin AT_DIRECT_SUPER = new TestLogin("at-direct-super");

    public static final TestLogin AT_DIRECT_WEB_SUPER = new TestLogin("at-direct-web-super");

    public static final TestLogin AT_DIRECT_IMAGE_C = new TestLogin("at-direct-image-c");

    public static final TestLogin AT_DIRECT_EXCEL_C = new TestLogin("at-direct-excel-c");

    public static final TestLogin AT_DIRECT_ADD_BANNER = new TestLogin("at-direct-add-banner");

    public static final TestLogin AT_DIRECT_COPY_USD = new TestLogin("at-direct-copy-usd");

    public static final TestLogin AT_DIRECT_COPY_RUB = new TestLogin("at-direct-copy-rub")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_BANNERGRCH_C = new TestLogin("at-direct-bannergrch-c");

    public static final TestLogin AT_DIRECT_BANNERCR_C = new TestLogin("at-direct-bannercr-c");

    public static final TestLogin AT_DIRECT_BANNERPARAM_D1 = new TestLogin("at-direct-bannerparam-d1");

    public static final TestLogin AT_DIRECT_SERV_CPA = new TestLogin("at-direct-serv-cpa");

    public static final TestLogin AT_DIRECT_PHRASEED_C = new TestLogin("at-direct-phraseed-c");

    public static final TestLogin AT_DIRECT_BANNERPARAM_C = new TestLogin("at-direct-bannerparam-c");

    public static final TestLogin AT_DIRECT_VIEWSLINK_C1 = new TestLogin("at-direct-viewslink-c1");

    public static final TestLogin AT_DIRECT_API_TEST = new TestLogin("at-direct-api-test")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DIRECT_BG_CLIENT = new TestLogin("at-direct-bg-client");

    public static final TestLogin AT_DIRECT_EDAGREP_A5 = new TestLogin("at-direct-edagrep-a5");

    public static final TestLogin AT_DIRECT_EXCEL_C1 = new TestLogin("at-direct-excel-c1");

    public static final TestLogin AT_DIRECT_HASAPILINK = new TestLogin("at-direct-hasapilink");

    public static final TestLogin AT_SHOWCAMPS_TABLE_CLIENT = new TestLogin("at-showcamps-table-client");

    public static final TestLogin AT_DIRECT_TRANSFER_RUB = new TestLogin("at-direct-transfer-rub");

    public static final TestLogin AT_DIRECT_MOBILE_CAMPADDDEL_C = new TestLogin("at-direct-mobile-campadddel-c");

    public static final TestLogin AT_DIRECT_PHRASESPARAMS_C = new TestLogin("at-direct-phrasesparams-c");

    public static final TestLogin AT_DIRECT_GEOTARGET_C = new TestLogin("at-direct-geotarget-c");

    public static final TestLogin AT_TESTER_SECOND_STEP = new TestLogin("at-tester-second-step");

    public static final TestLogin AT_DIRECTWEB_ADJASTMENT = new TestLogin("at-directweb-adjastment");

    public static final TestLogin AT_DIRECT_STOP_BANNERS_CLIENT = new TestLogin("at-direct-stop-banners-client");

    public static final TestLogin AT_DIRECT_APILINK_WITHAGENCY = new TestLogin("at-direct-apilink-withagency");

    public static final TestLogin AT_DIRECT_COPY_RUB1 = new TestLogin("at-direct-copy-rub1");

    public static final TestLogin AT_DIRECT_EDITPHRASES_ = new TestLogin("at-direct-editphrases-");

    public static final TestLogin AT_DIRECT_HASNTAPILINK = new TestLogin("at-direct-hasntapilink");

    /**
     * Пользователь с кампанией в проде, используется в тесте копирования статистики
     */
    public static final TestLogin TINGOL88 = new TestLogin("tingol88");

    public static final TestLogin API_SERV_NOCURRENCY = new TestLogin("api-serv-nocurrency");

    public static final TestLogin API_SERV_NOCURRENCY2 = new TestLogin("api-serv-nocurrency2")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin API_SERV_CHF = new TestLogin("api-serv-chf");

    public static final TestLogin API_SERV_EUR = new TestLogin("api-serv-eur");

    public static final TestLogin API_SERV_USD = new TestLogin("api-serv-usd");

    public static final TestLogin AT_CAPMEDITPAGE_C = new TestLogin("at-capmeditpage-c")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_DAYBUDGET_C = new TestLogin("at-daybudget-c");

    public static final TestLogin AT_DAYBUDGET_CLIENT = new TestLogin("at-daybudget-client")
            .withAgency(AT_DAYBUDGET_AG);

    public static final TestLogin AT_DAYBUDGET_CL5 = new TestLogin("at-daybudget-cl5");

    public static final TestLogin AT_DAYBUDGET_CL6 = new TestLogin("at-daybudget-cl6")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin MEDIAPLANNER = new TestLogin("at-direct-media-new");

    public static final TestLogin CLIENT_WITH_SEGMENTS = new TestLogin("at-direct-retargeting-web");

    public static final TestLogin MEDIAPLAN_SERVICED_CLIENT = new TestLogin("at-mediaplan-c")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_MEDIAPLAN_RET1 = new TestLogin("at-mediaplan-ret1")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_MEDIAPLAN_RET2 = new TestLogin("at-mediaplan-ret2")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_MEDIAPLAN_RET3 = new TestLogin("at-mediaplan-ret3")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_MEDIAPLAN_RET4 = new TestLogin("at-mediaplan-ret4")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_PRICECONSTRUCTOR_C = new TestLogin("at-priceconstructor-c");

    public static final TestLogin AT_RETARG_BANNER_C = new TestLogin("at-retarg-banner-c");

    public static final TestLogin AT_RETARG_FIELDS_BANNER_C = new TestLogin("at-retarg-fields-banner-c");

    public static final TestLogin AT_RETARG_MOBILEAPP = new TestLogin("at-retarg-mobileapp");

    public static final TestLogin AT_RETARG_RETARG_C = new TestLogin("at-retarg-retarg-c");

    public static final TestLogin AT_STRATEGIES_C = new TestLogin("at-strategies-c");

    public static final TestLogin AT_STRATEGIES_C_IC = new TestLogin("at-strategies-c-ic");

    public static final TestLogin AT_STRATEGIES_RUB = new TestLogin("at-strategies-rub");

    public static final TestLogin AT_TIMETARGETING_CLIENT = new TestLogin("at-timetargeting-client");

    public static final TestLogin AT_DIRECT_PHRASE_PRICES_C = new TestLogin("at-direct-phrase-prices-c");

    public static final TestLogin AT_DIRECT_METRIKA_COUNTER = new TestLogin("at-direct-metrika-counter")
            .withMetrikaCounters(of(47422879L, 47422918L, 47422897L, 47422912L, 47422891L, 1289034L));

    public static final TestLogin AT_WALLET_DAY_BUDGET_A = new TestLogin("at-wallet-day-budget-a");

    public static final TestLogin AT_WALLET_DAY_BUDGET_B = new TestLogin("at-wallet-day-budget-b");

    public static final TestLogin AT_WALLET_DAY_BUDGET_V = new TestLogin("at-wallet-day-budget-v");

    public static final TestLogin AT_WALLET_DAY_BUDGET_3T = new TestLogin("at-wallet-day-budget-3t");

    public static final TestLogin AT_TURBOLANDINGPAGE_TESTER = new TestLogin("at-turbolandingpage-tester")
            .withTurboLandings(of(
                    new TurboLandingInfoWeb()
                            .withName("Мой Турболендинг1")
                            .withId(10000848L)
                            .withHref("https://yandex.ru/turbo?text=lpc-testing/264e4e80c0a5237a1a0de3757e98ef776240d8c1dd7fef1744bd451d7b3fc898"),
                    new TurboLandingInfoWeb()
                            .withName("Мой Турболендинг2")
                            .withId(10000849L)
                            .withHref("https://yandex.ru/turbo?text=lpc-testing/f3518d6050e3a507e885a1b338b76901fac831ae3da9285ed39e87c74561124c")
            ));


    public static final TestLogin AT_DIRECT_VIDEO_ADDITIONS = new TestLogin("at-direct-video-additions")
            .withVideos(of(
                    new VideoInfoWeb()
                            .withName("Video1")
                            .withId(1091944806L),
                    new VideoInfoWeb()
                            .withName("Video2")
                            .withId(1092188810L)
            ));

    public static final TestLogin AT_CPM_TESTER = new TestLogin("at-cpm-tester");

    public static final TestLogin AT_CAMPAIGN_MNGR_SERVICED = new TestLogin("at-campaign-mngr-serviced")
            .withManager(AT_DIRECT_MNGR_FULL);

    /**
     * Логины для тестов с финансами
     */

    public static final TestLogin AT_DIRECT_FINANCE_TRANSFER_MNGR = new TestLogin("at-direct-transfer-mngr");

    public static final TestLogin AT_DIRECT_MNGR_NEW_LOGINS = new TestLogin("at-direct-mngr-new-logins");

    public static final TestLogin AT_DIRECT_FINANCE_AGENCY_FULL = new TestLogin("at-direct-ag-full");

    public static final TestLogin AT_DIRECT_FINANCE_PAYMENT_LOGIN = new TestLogin("at-direct-back-finance");

    public static final TestLogin AT_DIRECT_FINANCE_PAYMENT_LOGIN_WITHOUT_WALLET = new TestLogin("at-direct-without-wallet");

    public static final TestLogin AT_DIRECT_FINANCE_PAYMENT_SERVECED_CLIENT = new TestLogin("at-direct-adv-std")
            .withManager(AT_DIRECT_FINANCE_TRANSFER_MNGR);

    //агентство
    public static final TestLogin AT_DIRECT_FINANCE_PAYMENT_AGENCY = new TestLogin("test-agency-rub");

    public static final TestLogin AT_DIRECT_AGENCY_ADM = new TestLogin("at-direct-agency-adm");

    public static final TestLogin AT_DIRECT_AGENCY_CLIENT_REPRESENTER = new TestLogin("test-agency-rub-rep1");

    public static final TestLogin AT_DIRECT_AGENCY_CLIENT_OF_REPRESENTER = new TestLogin("at-direct-agency-client5");

    public static final TestLogin AT_DIRECT_FINANCE_PAYMENT_AGENCY_CLIENT = new TestLogin("test-agency-rub-client-rub")
            .withAgency(AT_DIRECT_FINANCE_PAYMENT_AGENCY);

    public static final TestLogin TRANSFER_AGENCY_CLIENT_RUB_1 = new TestLogin("transfer-agency-client-rub-1")
            .withAgency(AT_DIRECT_FINANCE_PAYMENT_AGENCY);

    public static final TestLogin TRANSFER_AGENCY_CLIENT_RUB_2 = new TestLogin("transfer-agency-client-rub-2")
            .withAgency(AT_DIRECT_FINANCE_PAYMENT_AGENCY);

    public static final TestLogin AT_DIRECT_FINANCE_YANDEX_MONEY_PAYMENT = new TestLogin("spb-tester");

    public static final TestLogin AT_DIRECT_FINANCE_WALLET_AGENCY = new TestLogin("at-agency-tmoney");

    public static final TestLogin AT_DIRECT_FINANCE_WALLET_AGENCY_CLIENT_1 = new TestLogin("at-sc-tm1")
            .withAgency(AT_DIRECT_FINANCE_WALLET_AGENCY);

    public static final TestLogin AT_DIRECT_FINANCE_WALLET_AGENCY_CLIENT_2 = new TestLogin("at-sc-tm2")
            .withAgency(AT_DIRECT_FINANCE_WALLET_AGENCY);

    public static final TestLogin AT_DIRECT_FINANCE_WALLET_AGENCY_CLIENT_WITHOUT_WALLET = new TestLogin("at-agency-client-no-wallet")
            .withAgency(AT_DIRECT_FINANCE_WALLET_AGENCY);

    public static final TestLogin AT_CPM_DEALS_TESTER = new TestLogin("at-cpm-deals-tester-2")
            .withAgency(AT_DIRECT_AGENCY);

    public static final TestLogin AT_AGENCY_CLIENT_WALLET = new TestLogin("at-agency-client-wallet")
            .withAgency(AT_DIRECT_FINANCE_WALLET_AGENCY);

    public static final TestLogin AT_DIRECT_B_SHOWRETARGETING = new TestLogin("at-direct-b-showretargeting")
            .withManager(AT_DIRECT_MNGR_FULL);

    public static final TestLogin AT_LOGGER_TESTER = new TestLogin("at-logger-tester");

    public static final TestLogin AT_TRANSFER_WITHOUT_WALLET = new TestLogin("at-transfer-without-wallet")
            .withManager(AT_DIRECT_FINANCE_TRANSFER_MNGR);

    public static final TestLogin AT_DIRECT_AUTOOVERDRAFT = new TestLogin("at-direct-autooverdraft1");

    //представитель клиента
    public static final TestLogin AT_DIRECT_REP = new TestLogin("at-direct-rep");
}
