package ru.yandex.autotests.direct.web.data;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.utils.textresource.TextResources.getText;

/**
 * @author : Alex Samokhin (alex-samo@yandex-team.ru)
 *         Date: 07.04.14
 */
public enum TransferTextResources implements ITextResource {

    //Ошибка: Перенос средств с кампании, обслуживаемой персональным менеджером, на обычную кампанию невозможен
    TRANSFER_SERVICED_TO_OWNED_ERROR,
    // -
    EMPTY_CAMPAIGNS_LIST_VALUE,
    //Сейчас нет оплаченных рекламных кампаний, доступных для переноса средств.
    NO_PAID_CAMPAIGNS_ERROR,
    //Ошибка: Остаток средств на кампании № %s не может быть меньше %s %s
    TRANSFER_SUM_SHORTAGE_ERROR,
    //Ошибка: Перевод на кампанию № %s возможен на сумму не менее %s %s
    TRANSFER_SUM_EXCEEDED_ERROR,
    //Ошибка: Выберите кампании, с которых хотите перенести средства.
    NO_FROM_CAMPAIGNS_SELECTED_ERROR,
    //Ошибка: Выберите кампании, на которые хотите перенести средства.
    NO_TO_CAMPAIGNS_SELECTED_ERROR,
    TRANSFER_ACCOUNT_REST_ERROR,
    ACCOUNT_CONNECT_TIMEOUT_ERROR,
    ACCOUNT_DISABLE_NEGATIVE_REST_ERROR,
    ACCOUNT_DISABLE_ARCHIVED_CAMPAIGNS_ERROR;

    private static final String BUNDLE = "web.transfer.Transfer";

    @Override
    public String getBundle() {
        return BUNDLE;
    }

    @Override
    public String toString() {
        return getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }


}
