package ru.yandex.autotests.direct.web.data.autopayment;


import java.util.stream.Stream;

import com.google.gson.annotations.SerializedName;

public enum AutoPaymentTypeEnum {
    @SerializedName("card")
    CARD("card"),
    @SerializedName("yandex_money")
    YANDEX_MONEY("yandex_money");

    private String value;

    AutoPaymentTypeEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public static AutoPaymentTypeEnum getEnumByValue(String value) {
        return Stream.of(values())
                .filter(t -> t.getValue().equals(value))
                .findFirst().orElse(null);
    }
}
