package ru.yandex.autotests.direct.web.data.banners;

import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

import static java.lang.String.format;

public enum CpmTargetingType {
    USER_PROFILE("crypta", "профиль пользователей"),
    KEYWORDS("keywords", "ключевые фразы");

    CpmTargetingType(String value, String textValue) {
        this.value = value;
        this.textValue = textValue;
    }

    private String value;
    private String textValue;

    public String getValue() {
        return value;
    }

    public String getTextValue() {
        return textValue;
    }

    public static CpmTargetingType getTypeByTextValue(String textValue) {
        return Stream.of(CpmTargetingType.values())
                .filter(x -> x.textValue.equals(textValue))
                .findFirst()
                .orElseThrow(() -> new DirectWebError(format("Тип с текстом \"%s\" не найден", textValue)));
    }
}