package ru.yandex.autotests.direct.web.data.banners;

import java.util.function.Predicate;
import java.util.stream.Stream;

import ru.yandex.autotests.direct.web.util.DirectWebError;

public enum DirectBannerType {
    TEXT("text", "Текстово-графическое"),
    IMAGE_AD("image_ad", "Графическое"),
    VIDEO("cpc_video", "Видео");

    private String value;
    private String textDescription;

    DirectBannerType(String value, String textDescription) {
        this.value = value;
        this.textDescription = textDescription;
    }

    @Override
    public String toString() {
        return value;
    }

    public String getValue() {
        return this.value;
    }

    public static DirectBannerType getDirectBannerTypeByValue(String value) {
        return getDirectBannerTypeByPredicate(t -> t.value.equals(value), "со значением " + value);
    }

    public static DirectBannerType getDirectBannerTypeByTextDescription(String value) {
        return getDirectBannerTypeByPredicate(t -> t.textDescription.equals(value), "с текстовым значением " + value);
    }

    public static DirectBannerType getDirectBannerTypeByPredicate(Predicate<DirectBannerType> predicate,
            String description)
    {
        return Stream.of(values())
                .filter(predicate)
                .findFirst()
                .orElseThrow(() -> new DirectWebError("Не найдено элемента, " + description));
    }
}
