package ru.yandex.autotests.direct.web.data.banners;

import java.util.NoSuchElementException;
import java.util.stream.Stream;

public enum MobileBannerAdditionalEnum {
    CUSTOMER_RATING("рейтинг"),
    PRICE("цена"),
    RATINGS("количество оценок"),
    ICON("иконка");

    private String text;

    MobileBannerAdditionalEnum(String text) {
        this.text = text;
    }

    public String getValue() {
        return text;
    }

    public static MobileBannerAdditionalEnum getByTextValue(String value) {
        return Stream.of(values())
                .filter(x -> x.getValue().equals(value))
                .findFirst()
                .orElseThrow(NoSuchElementException::new);
    }
}
