package ru.yandex.autotests.direct.web.data.banners;

import ru.yandex.autotests.direct.web.data.groupenums.TargetAudienceEnum;

public class PerformanceGroupChangesInfo {
    private TargetAudienceEnum targetingAudience;
    private TreeAvailabilityEnum availability;
    private String priceLowBoundary;
    private String priceHighBoundary;
    private boolean selectAllCategories;
    private PerformanceGroupChangesBlockTabs targetTab;

    public static PerformanceGroupChangesInfo change() {
        return new PerformanceGroupChangesInfo();
    }

    public TargetAudienceEnum getTargetingAudience() {
        return targetingAudience;
    }

    public TreeAvailabilityEnum getAvailability() {
        return availability;
    }

    public String getPriceLowBoundary() {
        return priceLowBoundary;
    }

    public String getPriceHighBoundary() {
        return priceHighBoundary;
    }

    public boolean isSelectAllCategories() {
        return selectAllCategories;
    }

    public PerformanceGroupChangesBlockTabs getTargetTab() {
        return targetTab;
    }

    public PerformanceGroupChangesInfo setTargetingAudience(TargetAudienceEnum targetingAudience) {
        this.targetingAudience = targetingAudience;
        return this;
    }

    public PerformanceGroupChangesInfo setAvailability(TreeAvailabilityEnum availability) {
        this.availability = availability;
        return this;
    }

    public PerformanceGroupChangesInfo setPriceLowBoundary(String priceLowBoundary) {
        this.priceLowBoundary = priceLowBoundary;
        return this;
    }

    public PerformanceGroupChangesInfo setPriceHighBoundary(String priceHighBoundary) {
        this.priceHighBoundary = priceHighBoundary;
        return this;
    }

    public PerformanceGroupChangesInfo setSelectAllCategories(boolean selectAllCategories) {
        this.selectAllCategories = selectAllCategories;
        return this;
    }

    public PerformanceGroupChangesInfo openTargetTab(PerformanceGroupChangesBlockTabs targetTab) {
        this.targetTab = targetTab;
        return this;
    }
}
