package ru.yandex.autotests.direct.web.data.banners;

import java.util.List;

import ru.yandex.autotests.direct.web.data.textresources.PhrasesTextData;
import ru.yandex.autotests.direct.web.util.DirectWebError;
import ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper;

import static java.util.Arrays.asList;
import static java.util.stream.Collectors.toList;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum PhrasePriority {
    LOW(PhrasesTextData.PHRASE_PRIORITY_LOW, "1"),
    MEDIUM(PhrasesTextData.PHRASE_PRIORITY_MEDIUM, "3"),
    HIGH(PhrasesTextData.PHRASE_PRIORITY_HIGH, "5");

    private String priorityValue;
    private PhrasesTextData priorityText;

    PhrasePriority(PhrasesTextData priorityText, String priorityValue) {
        this.priorityText = priorityText;
        this.priorityValue = priorityValue;
    }

    public static List<String> priorityValues() {
        return asList(PhrasePriority.values()).stream()
                .map(PhrasePriority::getPriorityValue)
                .collect(toList());
    }

    public static PhrasePriority getPhrasePriority(String priorityText) {
        for (PhrasePriority priority : PhrasePriority.values()) {
            if (priority.getPriorityText().equals(priorityText)) {
                return priority;
            }
        }
        throw new DirectWebError("Неверный приоритет фразы: " + priorityText);
    }

    public static PhrasePriority getPhrasePriorityByValue(String priorityValue) {
        for (PhrasePriority priority : PhrasePriority.values()) {
            if (priority.getPriorityValue().equals(priorityValue)) {
                return priority;
            }
        }
        throw new DirectWebError("Неверный приоритет фразы: " + priorityValue);
    }

    public String getPriorityValue() {
        return priorityValue;
    }

    public String getPriorityText() {
        return TextResourceHelper.resource(priorityText).toString();
    }
}
