package ru.yandex.autotests.direct.web.data.banners;

import java.util.stream.Stream;

/**
 * Created by aleran on 13.10.2015.
 */
public enum ReflectedAttrsEnum {
    RATING("rating"),
    RATING_VOTES("ratingVotes"),
    PRICE("price"),
    ICON("icon");

    private String value;

    ReflectedAttrsEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }

    public ReflectedAttrsEnum getReflectedAttrsByValue(String value) {
        return Stream.of(values()).filter(t -> t.getValue().equals(value)).findFirst().orElse(null);
    }
}
