package ru.yandex.autotests.direct.web.data.contactinfo;

import java.util.List;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;
import ru.yandex.autotests.direct.web.util.DirectWebError;

/**
 * @author Roman Kuhta (kuhtich@yandex-team.ru)
 */
public enum Regions implements ITextResource {
    RUSSIA("225", "Россия"),
    MOSCOW_AND_AREA("1"),
    MOSCOW("213"),
    SAINT_PETERSBURG("2"),
    SAINT_PETERSBURG_AND_AREA("10174"),
    UKRAINE("187"),
    CIS("166"),
    GEORGIA("169"),
    KAZAKHSTAN("159"),
    TURKEY("983"),
    USA("84"),
    ABKHAZIA("29386", "Абхазия"),
    TAJIKISTAN("209", "Таджикистан"),
    SPAIN("204", "Испания"),
    CENTER("3"),
    SOUTH("26"),
    AUSTRALIA_AND_OCEANIA("138"),
    JAPAN("137"),
    ASIA("183"),
    AFRICA("241"),
    NORTH_AMERICA("100002"),
    SOUTH_AMERICA("100003"),
    EUROPE("111"),
    CRIMEA("977"), //транслокальный регион с особой логикой, подробнее в DIRECT-30300
    RUSSIA_WITHOUT_CRIMEA("225"),
    EMPTY("0");

    Regions(String regionID, String regionName) {
        this.regionID = regionID;
        this.regionName = regionName;
    }

    Regions(String regionID) {
        this.regionID = regionID;
    }

    private String regionID;
    private String regionName;

    public String getRegionID() {
        return regionID;
    }

    public String getRegionName() {
        return regionName;
    }

    public static Regions getRegion(String regionText) {
        for (Regions region : Regions.values()) {
            if (region.toString().equals(regionText)) {
                return region;
            }
        }
        throw new DirectWebError("Регион " + regionText + " не найден");
    }

    public static Regions getRegionByID(String regionID) {
        for (Regions region : Regions.values()) {
            if (region.getRegionID().equals(regionID)) {
                return region;
            }
        }
        throw new DirectWebError("Регион " + regionID + " не найден");
    }

    public static List<String> getAllWorldIDs() {
        return java.util.Arrays.asList(
                RUSSIA.getRegionID(),
                CIS.getRegionID(),
                EUROPE.getRegionID(),
                ASIA.getRegionID(),
                AFRICA.getRegionID(),
                NORTH_AMERICA.getRegionID(),
                SOUTH_AMERICA.getRegionID(),
                AUSTRALIA_AND_OCEANIA.getRegionID());
    }

    @Override
    public String getBundle() {
        return "web.campaigns.Regions";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
