package ru.yandex.autotests.direct.web.data.converters;

import java.util.Collections;
import java.util.List;

import org.apache.commons.collections4.CollectionUtils;

import ru.yandex.autotests.direct.cmd.data.commons.banner.Callout;

import static java.util.stream.Collectors.toList;

public class CalloutsConverter {

    public static List<Callout> toCmdCallouts(List<String> callouts) {
        return CollectionUtils.isEmpty(callouts) ?
                Collections.emptyList() :
                callouts.stream()
                        .map(x -> new Callout().withCalloutText(x))
                        .collect(toList());
    }


    public static List<String> toInfoWebCallouts(List<Callout> callouts) {
        return CollectionUtils.isEmpty(callouts) ?
                null :
                callouts.stream()
                        .map(x -> x.getCalloutText())
                        .collect(toList());
    }
}
