package ru.yandex.autotests.direct.web.data.converters;

import ru.yandex.autotests.direct.utils.strategy.objects.CampaignStrategyInfoWeb;
import ru.yandex.autotests.direct.web.objects.campaigns.parameters.CampaignContextStrategyWeb;

import static java.util.Objects.isNull;

public class CampaignStrategyConverter {

    public static CampaignContextStrategyWeb toCampaignContextStrategyWeb(CampaignStrategyInfoWeb strategyInfoWeb) {
        CampaignContextStrategyWeb contextStrategyWeb = new CampaignContextStrategyWeb();
        contextStrategyWeb.setStrategyName(strategyInfoWeb.getStrategyName());
        contextStrategyWeb.setContextLimit(strategyInfoWeb.getContextLimit());
        contextStrategyWeb.setContextLimitSum(strategyInfoWeb.getContextLimitSum());
        contextStrategyWeb.setContextPricePercent(strategyInfoWeb.getContextPricePercent());
        contextStrategyWeb.setMaxPrice(isNull(strategyInfoWeb.getMaxPrice()) ? null : strategyInfoWeb.getMaxPrice().floatValue());
        contextStrategyWeb.setAverageCpa(isNull(strategyInfoWeb.getAverageCPA()) ? null : strategyInfoWeb.getAverageCPA().floatValue());
        contextStrategyWeb.setWeeklySumLimit(isNull(strategyInfoWeb.getWeeklySumLimit()) ? null : strategyInfoWeb.getWeeklySumLimit().floatValue());
        contextStrategyWeb.setClicksPerWeek(strategyInfoWeb.getClicksPerWeek());
        contextStrategyWeb.setAveragePrice(isNull(strategyInfoWeb.getAveragePrice()) ? null : strategyInfoWeb.getAveragePrice().floatValue());
        contextStrategyWeb.setGoalId(strategyInfoWeb.getGoalID());
        contextStrategyWeb.setReserveReturn(strategyInfoWeb.getReserveReturn());
        contextStrategyWeb.setRoiCoef(isNull(strategyInfoWeb.getROICoef()) ? null : strategyInfoWeb.getROICoef().floatValue());
        contextStrategyWeb.setProfitability(isNull(strategyInfoWeb.getProfitability()) ? null : strategyInfoWeb.getProfitability().floatValue());
        return contextStrategyWeb;
    }
}
