package ru.yandex.autotests.direct.web.data.converters;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.autotests.direct.cmd.data.commons.group.Group;
import ru.yandex.autotests.direct.web.objects.groups.McGroupInfoWeb;

import static java.lang.Long.parseLong;
import static java.util.Objects.isNull;
import static java.util.stream.Collectors.toList;

public class McGroupInfoWebConverter {
    public static McGroupInfoWeb cmdGroupToMcGroupInfoWeb(Group cmdGroup) {
        return new McGroupInfoWeb()
                .withAdGroupID(StringUtils.isEmpty(cmdGroup.getAdGroupID()) ? null
                        : parseLong(cmdGroup.getAdGroupID()))
                .withAdGroupName(cmdGroup.getAdGroupName())
                .withGeo(cmdGroup.getGeo())
                .withMinusKeywords(isNull(cmdGroup.getMinusWords()) ? null
                        : cmdGroup.getMinusWords().stream().toArray(String[]::new))
                .withBanners(isNull(cmdGroup.getBanners()) ? null :
                        cmdGroup.getBanners().stream().map(McBannerInfoWebConverter::cmdBannerToMcBannerInfoWeb)
                                .collect(toList()));

    }
}
