package ru.yandex.autotests.direct.web.data.converters;

import org.apache.commons.collections.CollectionUtils;

import ru.yandex.autotests.direct.cmd.data.commons.phrase.Phrase;
import ru.yandex.autotests.direct.web.objects.banners.BannerPhraseInfoWeb;

import static java.util.Objects.isNull;

//TODO: Обсудить поведение при цене меньше 0.3, кажется тут надо кидать исключение, а не делать молча замену
public class PhraseInfoWebConverter {
    private static final double MIN_PRICE_RUB = 0.30;
    private static final double MEDIUM_AUTOBUDGET_PRIORITY = 3.0;
    private static final String STRING_MEDIUM_AUTOBUDGET_PRIORITY = "Medium";

    public static Phrase toCmdPhrase(BannerPhraseInfoWeb bannerPhraseInfoWeb) {
        return new Phrase()
                .withPhrase(bannerPhraseInfoWeb.getPhrase())
                .withId(0L)
                .withPrice(isNull(bannerPhraseInfoWeb.getPrice()) || bannerPhraseInfoWeb.getPrice() < MIN_PRICE_RUB ?
                        MIN_PRICE_RUB
                        : (double) bannerPhraseInfoWeb.getPrice())
                .withPriceContext(
                        isNull(bannerPhraseInfoWeb.getContextPrice())
                                || bannerPhraseInfoWeb.getContextPrice() < MIN_PRICE_RUB ? MIN_PRICE_RUB
                                : (double) bannerPhraseInfoWeb.getContextPrice())
                .withAutobudgetPriority(MEDIUM_AUTOBUDGET_PRIORITY);
    }

    public static BannerPhraseInfoWeb toInfoWebPhrase(Phrase phrase) {
        return new BannerPhraseInfoWeb().withPhrase(phrase.getPhrase())
                .withPhraseID(phrase.getId())
                .withPrice(isNull(phrase.getPrice()) || phrase.getPrice() < MIN_PRICE_RUB ?
                        (float) MIN_PRICE_RUB :
                        phrase.getPrice().floatValue())
                .withContextPrice(isNull(phrase.getPriceContext()) || phrase.getPriceContext() < MIN_PRICE_RUB ?
                        (float) MIN_PRICE_RUB :
                        phrase.getPriceContext().floatValue())
                .withAutoBudgetPriority(STRING_MEDIUM_AUTOBUDGET_PRIORITY)
                .withClicks(isNull(phrase.getClicks()) ? null : phrase.getClicks().intValue())
                .withShows(isNull(phrase.getShows()) ? null : phrase.getShows().intValue());
    }
}
