package ru.yandex.autotests.direct.web.data.converters;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.autotests.direct.cmd.data.commons.banner.Banner;
import ru.yandex.autotests.direct.cmd.data.commons.banner.SiteLink;
import ru.yandex.autotests.direct.cmd.data.commons.banner.TurboLanding;
import ru.yandex.autotests.direct.web.objects.banners.commons.SiteLinkInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.TurboLandingInfoWeb;

import static java.util.Objects.isNull;
import static java.util.stream.Collectors.toList;
import static org.codehaus.groovy.runtime.InvokerHelper.asList;

public class SiteLinkInfoWebConverter {
    private static final int SITELINK_AMOUNT = 4; //Всегда необходимо отправлять ровно 4 ссылки
    private static final String DEFAULT_PROTOCOL = "http://";

    public static SiteLink toCmdSiteLink(SiteLinkInfoWeb siteLinkInfoWeb) {
        String href = siteLinkInfoWeb.getHref();
        int lastSlashIndex = href.indexOf("://");
        SiteLink result = new SiteLink();
        String resultHref = lastSlashIndex == -1 ? siteLinkInfoWeb.getHref() : href.substring(lastSlashIndex + 3);
        String protocol = lastSlashIndex == -1 ? DEFAULT_PROTOCOL : href.substring(0, lastSlashIndex + 3);
        TurboLanding turboLanding = null;
        if (siteLinkInfoWeb.getTurboLanding() != null) {
            turboLanding = new TurboLanding()
                    .withId(siteLinkInfoWeb.getTurboLanding().getId())
                    .withHref(siteLinkInfoWeb.getTurboLanding().getHref());
        }
        return new SiteLink().withTitle(siteLinkInfoWeb.getTitle())
                .withTurboLanding(turboLanding)
                .withUrlProtocol(protocol)
                .withHref(resultHref);
    }

    public static List<SiteLink> toExpandedCmdSiteLinks(SiteLinkInfoWeb... siteLinkInfoWebList) {
        return toExpandedCmdSiteLinks(asList(siteLinkInfoWebList));
    }

    public static List<SiteLink> toExpandedCmdSiteLinks(List<SiteLinkInfoWeb> siteLinkInfoWebList) {
        return isNull(siteLinkInfoWebList) || siteLinkInfoWebList.isEmpty() ?
                expandSiteLinkList(null)
                : expandSiteLinkList(siteLinkInfoWebList.stream().map(x -> toCmdSiteLink(x)).collect(toList()));
    }

    public static List<SiteLink> expandSiteLinkList(List<SiteLink> siteLinks) {
        if (isNull(siteLinks)) {
            siteLinks = new ArrayList<>(SITELINK_AMOUNT);
        }
        while (siteLinks.size() < SITELINK_AMOUNT) {
            siteLinks.add(SiteLink.getEmptySiteLink());
        }
        return siteLinks;
    }

    public static void expandSiteLinks(Banner banner) {
        banner.withSiteLinks(expandSiteLinkList(banner.getSiteLinks()));
    }

    public static SiteLinkInfoWeb[] toInfoWebSiteLinks(List<SiteLink> siteLinks) {
        return isNull(siteLinks) || siteLinks.isEmpty() ? null
                : siteLinks.stream()
                        .map(x -> {
                            TurboLandingInfoWeb turboLanding = null;
                            if (x.getTurboLanding() != null) {
                                turboLanding = new TurboLandingInfoWeb()
                                        .withId(x.getTurboLanding().getId())
                                        .withHref(x.getTurboLanding().getHref());
                            }
                            return new SiteLinkInfoWeb()
                                    .withTurboLanding(turboLanding)
                                    .withHref(x.getUrlProtocol() + x.getHref())
                                    .withTitle(x.getTitle());
                        })
                        .toArray(SiteLinkInfoWeb[]::new);
    }
}
