package ru.yandex.autotests.direct.web.data.factory;

import ru.yandex.autotests.direct.web.data.timetarget.TimeTargetInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.BannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.DynamicTextBannerWeb;
import ru.yandex.autotests.direct.web.objects.banners.MobileAppBannerInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.SearchBannersInfoWeb;
import ru.yandex.autotests.direct.web.objects.banners.commons.ContactInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.CpmGroupInfoWeb;
import ru.yandex.autotests.direct.web.objects.groups.DynamicTextGroupWeb;
import ru.yandex.autotests.direct.web.objects.groups.McGroupInfoWeb;
import ru.yandex.autotests.direct.web.objects.imagead.ImageAdWeb;
import ru.yandex.autotests.direct.web.objects.retargeting.RetargetingConditionWeb;
import ru.yandex.autotests.direct.web.util.beanutils.MongoPropertyLoader;

public class BeanFactories {

    public static BeanFactory<BannerInfoWeb> bannersFactory() {
        return buildFactory(BannerInfoWeb.class);
    }

    public static BeanFactory<MobileAppBannerInfoWeb> mobileBannerFactory() {
        return buildFactory(MobileAppBannerInfoWeb.class);
    }

    public static BeanFactory<ContactInfoWeb> contactInfoFactory() {
        return buildFactory(ContactInfoWeb.class);
    }

    public static BeanFactory<TimeTargetInfoWeb> timeTargetFactory() {
        return buildFactory(TimeTargetInfoWeb.class);
    }

    public static BeanFactory<SearchBannersInfoWeb> searchBannersFactory() {
        return buildFactory(SearchBannersInfoWeb.class);
    }

    public static BeanFactory<DynamicTextGroupWeb> dynamicGroupFactory() {
        return buildFactory(DynamicTextGroupWeb.class);
    }

    public static BeanFactory<DynamicTextBannerWeb> dynamicTextBannerFactory() {
        return buildFactory(DynamicTextBannerWeb.class);
    }

    public static BeanFactory<McGroupInfoWeb> mcGroupFactory() {
        return buildFactory(McGroupInfoWeb.class);
    }

    public static BeanFactory<RetargetingConditionWeb> retargetingConditionFactory() {
        return buildFactory(RetargetingConditionWeb.class);
    }

    public static BeanFactory<CpmGroupInfoWeb> cpmGroupFactory() {
        return buildFactory(CpmGroupInfoWeb.class);
    }

    public static BeanFactory<ImageAdWeb> imageAdFactory() {
        return buildFactory(ImageAdWeb.class);
    }

    private static <T> BeanFactory<T> buildFactory(Class<T> clazz) {
        return x -> new MongoPropertyLoader<>(clazz).getBean(x);
    }
}
