package ru.yandex.autotests.direct.web.data.firsthelp;

import ru.yandex.autotests.direct.utils.config.DirectTestRunProperties;
import ru.yandex.autotests.direct.utils.textresource.ITextResource;
import ru.yandex.autotests.direct.utils.textresource.TextResources;

/**
 * User: xy6er
 * Date: 02.07.13
 * Time: 15:16
 */

/**
 * Тип заявки в Первой и Второй помощи
 */
public enum HelpRequestType implements ITextResource {

    FIRST_HELP("firstaid"),
    FIRST_HELP_IN_WAITING_STATE(""),
    SECOND_HELP("secondaid"),
    AUTOMATIC("iseasy");

    private String id;

    HelpRequestType(String id) {
        this.id = id;
    }

    public String getId() {
        return id;
    }

    public static HelpRequestType getHelpRequestType(String name) {
        for (HelpRequestType helpRequestType : HelpRequestType.values()) {
            if (helpRequestType.toString().equals(name)) {
                return helpRequestType;
            }
        }
        return null;
    }

    @Override
    public String getBundle() {
        return "web.campaigns.firsthelp.HelpRequestType";
    }

    @Override
    public String toString() {
        return TextResources.getText(this, DirectTestRunProperties.getInstance().getDirectCmdLocale());
    }
}
