package ru.yandex.autotests.direct.web.data.firsthelp;

import ru.yandex.autotests.direct.utils.textresource.ITextResource;

import static ru.yandex.autotests.direct.web.util.helpers.TextResourceHelper.resource;


/**
 * User: xy6er
 * Date: 16.09.13
 * Time: 10:36
 */

public enum OptimizeAction implements ITextResource {

    OMISSIONS_ACTION(OptimizeGroupAction.BANNERS_TEXT_GROUP, OptimizeActionText.OMISSIONS_ACTION_TEXT),
    PRICE_ACTION(OptimizeGroupAction.IMPORTANT_FOR_SITE, OptimizeActionText.PRICE_ACTION_TEXT);

    OptimizeGroupAction group;
    OptimizeActionText text;

    OptimizeAction(OptimizeGroupAction group, OptimizeActionText text) {
        this.group = group;
        this.text = text;
    }

    public OptimizeGroupAction getGroup() {
        return group;
    }

    public String getText() {
        return text.toString();
    }

    public String getName() {
        return resource(this).toString();
    }

    @Override
    public String getBundle() {
        return "web.campaigns.firsthelp.FirstHelpConstants";
    }

    @Override
    public String toString() {
        return group.toString() + "/ " + getName();
    }
}
